/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.common.options.IsolatedOptionsData;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionsBase;
import java.util.Collection;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
final class OptionsData
extends IsolatedOptionsData {
    private final ImmutableMap<OptionDefinition, ImmutableList<String>> evaluatedExpansions;
    private static final ImmutableList<String> EMPTY_EXPANSION = ImmutableList.of();

    private OptionsData(IsolatedOptionsData base, Map<OptionDefinition, ImmutableList<String>> evaluatedExpansions) {
        super(base);
        this.evaluatedExpansions = ImmutableMap.copyOf(evaluatedExpansions);
    }

    public ImmutableList<String> getEvaluatedExpansion(OptionDefinition optionDefinition) {
        ImmutableList<String> result = this.evaluatedExpansions.get(optionDefinition);
        return result != null ? result : EMPTY_EXPANSION;
    }

    static OptionsData from(Collection<Class<? extends OptionsBase>> classes) {
        IsolatedOptionsData isolatedData = IsolatedOptionsData.from(classes);
        ImmutableMap.Builder<OptionDefinition, ImmutableList<String>> evaluatedExpansionsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, OptionDefinition> entry : isolatedData.getAllOptionDefinitions()) {
            OptionDefinition optionDefinition = entry.getValue();
            String[] constExpansion = optionDefinition.getOptionExpansion();
            if (constExpansion.length <= 0) continue;
            evaluatedExpansionsBuilder.put(optionDefinition, ImmutableList.copyOf(constExpansion));
        }
        return new OptionsData(isolatedData, evaluatedExpansionsBuilder.build());
    }
}

