/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionsData;
import com.google.devtools.common.options.OptionsParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class OptionsBase {
    private static final Escaper ESCAPER = new CharEscaperBuilder().addEscape('\\', "\\\\").addEscape('\"', "\\\"").toEscaper();

    protected OptionsBase() {
    }

    public final Map<String, Object> asMap() {
        ImmutableList<OptionDefinition> definitions = OptionsData.getAllOptionDefinitionsForClass(this.getClass());
        LinkedHashMap<String, Object> map = Maps.newLinkedHashMapWithExpectedSize(definitions.size());
        for (OptionDefinition definition : definitions) {
            map.put(definition.getOptionName(), this.getValueFromDefinition(definition));
        }
        return map;
    }

    public final Object getValueFromDefinition(OptionDefinition definition) {
        try {
            return definition.getField().get(this);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("All options fields of options classes should be public", e);
        }
    }

    public final String toString() {
        return this.getClass().getName() + this.asMap();
    }

    public final String cacheKey() {
        StringBuilder result = new StringBuilder(this.getClass().getName()).append("{");
        result.append(OptionsBase.mapToCacheKey(this.asMap()));
        return result.append("}").toString();
    }

    public static String mapToCacheKey(Map<?, ?> optionsMap) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<?, ?> entry : optionsMap.entrySet()) {
            result.append(entry.getKey()).append("=");
            Object value = entry.getValue();
            if (value instanceof List && ((List)value).isEmpty()) {
                result.append("EMPTY");
            } else if (value == null) {
                result.append("NULL");
            } else {
                result.append('\"').append(ESCAPER.escape(value.toString())).append('\"');
            }
            result.append(", ");
        }
        return result.toString();
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().equals(that.getClass())) {
            return false;
        }
        OptionsBase other = (OptionsBase)that;
        for (OptionDefinition def : OptionsParser.getOptionDefinitions(this.getClass())) {
            if (Objects.equals(this.getValueFromDefinition(def), other.getValueFromDefinition(def))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return this.getClass().hashCode() + this.asMap().hashCode();
    }
}

