/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionPriority;
import com.google.devtools.common.options.OptionsData;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.ParsedOptionDescription;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class OptionValueDescription {
    protected final OptionDefinition optionDefinition;
    @Nullable
    protected final Object conversionContext;

    public OptionValueDescription(OptionDefinition optionDefinition, @Nullable Object conversionContext) {
        this.optionDefinition = optionDefinition;
        this.conversionContext = conversionContext;
    }

    public OptionDefinition getOptionDefinition() {
        return this.optionDefinition;
    }

    public abstract Object getValue();

    public abstract boolean containsErrors();

    public abstract String getSourceString();

    abstract ExpansionBundle addOptionInstance(ParsedOptionDescription var1, Set<String> var2) throws OptionsParsingException;

    @Nullable
    public abstract List<ParsedOptionDescription> getCanonicalInstances();

    public static OptionValueDescription createOptionValueDescription(OptionDefinition option, OptionsData optionsData, @Nullable Object conversionContext) {
        if (option.isExpansionOption()) {
            return new ExpansionOptionValueDescription(option, optionsData, conversionContext);
        }
        if (option.allowsMultiple()) {
            return new RepeatableOptionValueDescription(option, conversionContext);
        }
        if (option.hasImplicitRequirements()) {
            return new OptionWithImplicitRequirementsValueDescription(option, conversionContext);
        }
        return new SingleOptionValueDescription(option, conversionContext);
    }

    public static OptionValueDescription getDefaultOptionValue(OptionDefinition option, @Nullable Object conversionContext) {
        return new DefaultOptionValueDescription(option, conversionContext);
    }

    private static class OptionWithImplicitRequirementsValueDescription
    extends SingleOptionValueDescription {
        private OptionWithImplicitRequirementsValueDescription(OptionDefinition optionDefinition, @Nullable Object conversionContext) {
            super(optionDefinition, conversionContext);
            if (!optionDefinition.hasImplicitRequirements()) {
                throw new OptionsParser.ConstructionException("Options without implicit requirements can't be tracked using OptionWithImplicitRequirementsValueDescription");
            }
        }

        @Override
        ExpansionBundle addOptionInstance(ParsedOptionDescription parsedOption, Set<String> warnings) throws OptionsParsingException {
            ExpansionBundle superExpansion = super.addOptionInstance(parsedOption, warnings);
            Preconditions.checkArgument(superExpansion == null, "SingleOptionValueDescription should not expand to anything.");
            if (parsedOption.getConvertedValue().equals(this.optionDefinition.getDefaultValue(this.conversionContext))) {
                warnings.add(String.format("%s sets %s to its default value. Since this option has implicit requirements that are set whenever the option is explicitly provided, regardless of the value, this will behave differently than letting a default be a default. Specifically, this options expands to {%s}.", parsedOption.getCommandLineForm(), this.optionDefinition, String.join((CharSequence)" ", this.optionDefinition.getImplicitRequirements())));
            }
            return new ExpansionBundle(ImmutableList.copyOf(this.optionDefinition.getImplicitRequirements()), parsedOption.getSource() == null ? String.format("implicit requirement of %s", this.optionDefinition) : String.format("implicit requirement of %s (source %s)", this.optionDefinition, parsedOption.getSource()));
        }
    }

    private static class ExpansionOptionValueDescription
    extends OptionValueDescription {
        private final List<String> expansion;

        private ExpansionOptionValueDescription(OptionDefinition optionDefinition, OptionsData optionsData, @Nullable Object conversionContext) {
            super(optionDefinition, conversionContext);
            this.expansion = optionsData.getEvaluatedExpansion(optionDefinition);
            if (!optionDefinition.isExpansionOption()) {
                throw new OptionsParser.ConstructionException("Options without expansions can't be tracked using ExpansionOptionValueDescription");
            }
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public boolean containsErrors() {
            return false;
        }

        @Override
        public String getSourceString() {
            return null;
        }

        @Override
        ExpansionBundle addOptionInstance(ParsedOptionDescription parsedOption, Set<String> warnings) {
            if (parsedOption.getUnconvertedValue() != null && !parsedOption.getUnconvertedValue().isEmpty()) {
                warnings.add(String.format("%s is an expansion option. It does not accept values, and does not change its expansion based on the value provided. Value '%s' will be ignored.", this.optionDefinition, parsedOption.getUnconvertedValue()));
            }
            return new ExpansionBundle(this.expansion, parsedOption.getSource() == null ? String.format("expanded from %s", this.optionDefinition) : String.format("expanded from %s (source %s)", this.optionDefinition, parsedOption.getSource()));
        }

        public ImmutableList<ParsedOptionDescription> getCanonicalInstances() {
            return ImmutableList.of();
        }
    }

    private static class RepeatableOptionValueDescription
    extends OptionValueDescription {
        private final ListMultimap<OptionPriority, ParsedOptionDescription> parsedOptions;
        private final ListMultimap<OptionPriority, Object> optionValues;
        private boolean containsErrors;

        private RepeatableOptionValueDescription(OptionDefinition optionDefinition, @Nullable Object conversionContext) {
            super(optionDefinition, conversionContext);
            if (!optionDefinition.allowsMultiple()) {
                throw new OptionsParser.ConstructionException("Can't have a repeated value for a non-allowMultiple option.");
            }
            this.parsedOptions = ArrayListMultimap.create();
            this.optionValues = ArrayListMultimap.create();
            this.containsErrors = false;
        }

        @Override
        public String getSourceString() {
            return this.parsedOptions.asMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).flatMap(Collection::stream).map(ParsedOptionDescription::getSource).distinct().collect(Collectors.joining(", "));
        }

        @Override
        public ImmutableList<Object> getValue() {
            return this.optionValues.asMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        }

        @Override
        public boolean containsErrors() {
            return this.containsErrors;
        }

        @Override
        @Nullable
        ExpansionBundle addOptionInstance(ParsedOptionDescription parsedOption, Set<String> warnings) throws OptionsParsingException {
            Object convertedValue;
            try {
                convertedValue = parsedOption.getConvertedValue();
            }
            catch (OptionsParsingException e) {
                this.containsErrors = true;
                throw e;
            }
            OptionPriority priority = parsedOption.getPriority();
            this.parsedOptions.put(priority, parsedOption);
            if (convertedValue instanceof List) {
                this.optionValues.putAll(priority, (List)convertedValue);
            } else {
                this.optionValues.put(priority, convertedValue);
            }
            return null;
        }

        public ImmutableList<ParsedOptionDescription> getCanonicalInstances() {
            return this.parsedOptions.asMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).flatMap(Collection::stream).filter(optionDesc -> optionDesc.getImplicitDependent() == null).collect(ImmutableList.toImmutableList());
        }
    }

    private static class SingleOptionValueDescription
    extends OptionValueDescription {
        private ParsedOptionDescription effectiveOptionInstance;
        private Object effectiveValue;
        private boolean containsErrors;

        private SingleOptionValueDescription(OptionDefinition optionDefinition, @Nullable Object conversionContext) {
            super(optionDefinition, conversionContext);
            if (optionDefinition.allowsMultiple()) {
                throw new OptionsParser.ConstructionException("Can't have a single value for an allowMultiple option.");
            }
            if (optionDefinition.isExpansionOption()) {
                throw new OptionsParser.ConstructionException("Can't have a single value for an expansion option.");
            }
            this.effectiveOptionInstance = null;
            this.effectiveValue = null;
            this.containsErrors = false;
        }

        @Override
        public Object getValue() {
            return this.effectiveValue;
        }

        @Override
        public boolean containsErrors() {
            return this.containsErrors;
        }

        @Override
        public String getSourceString() {
            return this.effectiveOptionInstance.getSource();
        }

        private Object convertValue(ParsedOptionDescription parsedOption) throws OptionsParsingException {
            try {
                return parsedOption.getConvertedValue();
            }
            catch (OptionsParsingException e) {
                this.containsErrors = true;
                throw e;
            }
        }

        @Override
        @Nullable
        ExpansionBundle addOptionInstance(ParsedOptionDescription parsedOption, Set<String> warnings) throws OptionsParsingException {
            if (this.effectiveOptionInstance == null) {
                this.effectiveOptionInstance = parsedOption;
                this.effectiveValue = this.convertValue(parsedOption);
                return null;
            }
            if (parsedOption.getPriority().compareTo(this.effectiveOptionInstance.getPriority()) >= 0) {
                ParsedOptionDescription implicitDependent = parsedOption.getImplicitDependent();
                ParsedOptionDescription expandedFrom = parsedOption.getExpandedFrom();
                ParsedOptionDescription optionThatDependsOnEffectiveValue = this.effectiveOptionInstance.getImplicitDependent();
                ParsedOptionDescription optionThatExpandedToEffectiveValue = this.effectiveOptionInstance.getExpandedFrom();
                Object newValue = this.convertValue(parsedOption);
                if (this.effectiveValue != null && !this.effectiveValue.equals(newValue)) {
                    boolean samePriorityCategory = parsedOption.getPriority().getPriorityCategory().equals((Object)this.effectiveOptionInstance.getPriority().getPriorityCategory());
                    if (implicitDependent != null && optionThatDependsOnEffectiveValue != null) {
                        if (!implicitDependent.equals(optionThatDependsOnEffectiveValue)) {
                            warnings.add(String.format("%s is implicitly defined by both %s and %s", this.optionDefinition, optionThatDependsOnEffectiveValue, implicitDependent));
                        }
                    } else if (implicitDependent != null && samePriorityCategory) {
                        warnings.add(String.format("%s is implicitly defined by %s; the implicitly set value overrides the previous one", this.optionDefinition, implicitDependent));
                    } else if (optionThatDependsOnEffectiveValue != null) {
                        warnings.add(String.format("A new value for %s overrides a previous implicit setting of that option by %s", this.optionDefinition, optionThatDependsOnEffectiveValue));
                    } else if (samePriorityCategory && parsedOption.getPriority().getPriorityCategory().equals((Object)OptionPriority.PriorityCategory.COMMAND_LINE) && optionThatExpandedToEffectiveValue == null && expandedFrom != null) {
                        warnings.add(String.format("%s was expanded and now overrides the explicit option %s with %s", expandedFrom, this.effectiveOptionInstance.getCommandLineForm(), parsedOption.getCommandLineForm()));
                    } else if (optionThatExpandedToEffectiveValue != null && expandedFrom != null) {
                        warnings.add(String.format("%s was expanded to from both %s and %s", this.optionDefinition, optionThatExpandedToEffectiveValue, expandedFrom));
                    }
                }
                this.effectiveOptionInstance = parsedOption;
                this.effectiveValue = newValue;
            }
            return null;
        }

        public ImmutableList<ParsedOptionDescription> getCanonicalInstances() {
            if (this.effectiveOptionInstance.getImplicitDependent() == null) {
                return ImmutableList.of(this.effectiveOptionInstance);
            }
            return ImmutableList.of();
        }
    }

    private static class DefaultOptionValueDescription
    extends OptionValueDescription {
        private DefaultOptionValueDescription(OptionDefinition optionDefinition, @Nullable Object conversionContext) {
            super(optionDefinition, conversionContext);
        }

        @Override
        public Object getValue() {
            return this.optionDefinition.getDefaultValue(this.conversionContext);
        }

        @Override
        public boolean containsErrors() {
            return false;
        }

        @Override
        public String getSourceString() {
            return null;
        }

        @Override
        ExpansionBundle addOptionInstance(ParsedOptionDescription parsedOption, Set<String> warnings) {
            throw new IllegalStateException("Cannot add values to the default option value. Create a modifiable OptionValueDescription using createOptionValueDescription() instead.");
        }

        public ImmutableList<ParsedOptionDescription> getCanonicalInstances() {
            return null;
        }
    }

    public static class ExpansionBundle {
        List<String> expansionArgs;
        String sourceOfExpansionArgs;

        public ExpansionBundle(List<String> args, String source) {
            this.expansionArgs = args;
            this.sourceOfExpansionArgs = source;
        }
    }
}

