/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.rendering;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class MarkdownUtil {
    private static final int MAX_LINE_LENGTH = 100;

    public String markdownCellFormat(String docString) {
        String resultString = this.htmlEscape(docString.trim());
        resultString = MarkdownUtil.replaceWithTag(resultString, "```", "<pre><code>", "</code></pre>");
        resultString = MarkdownUtil.replaceWithTag(resultString, "`", "<code>", "</code>");
        return resultString.replaceAll("\n(\\s*\n)+", "<br><br>").replace('\n', ' ');
    }

    private static String replaceWithTag(String wholeString, String stringToReplace, String openTag, String closeTag) {
        String remainingString = wholeString;
        StringBuilder resultString = new StringBuilder();
        boolean openTagNext = true;
        int index = remainingString.indexOf(stringToReplace);
        while (index > -1) {
            resultString.append(remainingString, 0, index);
            resultString.append(openTagNext ? openTag : closeTag);
            openTagNext = !openTagNext;
            remainingString = remainingString.substring(index + stringToReplace.length());
            index = remainingString.indexOf(stringToReplace);
        }
        resultString.append(remainingString);
        return resultString.toString();
    }

    public String htmlEscape(String docString) {
        return docString.replace("<", "&lt;").replace(">", "&gt;");
    }

    public String ruleSummary(String ruleName, StardocOutputProtos.RuleInfo ruleInfo) {
        List<String> attributeNames = ruleInfo.getAttributeList().stream().map(StardocOutputProtos.AttributeInfo::getName).collect(Collectors.toList());
        return MarkdownUtil.summary(ruleName, attributeNames);
    }

    public String providerSummary(String providerName, StardocOutputProtos.ProviderInfo providerInfo) {
        List<String> fieldNames = providerInfo.getFieldInfoList().stream().map(field -> field.getName()).collect(Collectors.toList());
        return MarkdownUtil.summary(providerName, fieldNames);
    }

    public String aspectSummary(String aspectName, StardocOutputProtos.AspectInfo aspectInfo) {
        List<String> attributeNames = aspectInfo.getAttributeList().stream().map(StardocOutputProtos.AttributeInfo::getName).collect(Collectors.toList());
        return MarkdownUtil.summary(aspectName, attributeNames);
    }

    public String funcSummary(StardocOutputProtos.StarlarkFunctionInfo funcInfo) {
        List<String> paramNames = funcInfo.getParameterList().stream().map(StardocOutputProtos.FunctionParamInfo::getName).collect(Collectors.toList());
        return MarkdownUtil.summary(funcInfo.getFunctionName(), paramNames);
    }

    private static String summary(String functionName, List<String> paramNames) {
        List<List<String>> paramLines = MarkdownUtil.wrap(functionName, paramNames, 100);
        ArrayList<String> paramLinksLines = new ArrayList<String>();
        for (List<String> params : paramLines) {
            String paramLinksLine = params.stream().map(param -> String.format("<a href=\"#%s-%s\">%s</a>", functionName, param, param)).collect(Collectors.joining(", "));
            paramLinksLines.add(paramLinksLine);
        }
        String paramList = Joiner.on(",\n" + " ".repeat(functionName.length() + 1)).join(paramLinksLines);
        return String.format("%s(%s)", functionName, paramList);
    }

    private static List<List<String>> wrap(String functionName, List<String> paramNames, int maxLineLength) {
        int leading;
        ArrayList<List<String>> paramLines = new ArrayList<List<String>>();
        ImmutableList.Builder linesBuilder = new ImmutableList.Builder();
        int length = leading = functionName.length();
        int punctuation = 2;
        for (String paramName : paramNames) {
            if ((length += paramName.length() + punctuation) > maxLineLength) {
                paramLines.add((List<String>)((Object)linesBuilder.build()));
                length = leading + paramName.length();
                linesBuilder = new ImmutableList.Builder();
            }
            linesBuilder.add(paramName);
        }
        paramLines.add((List<String>)((Object)linesBuilder.build()));
        return paramLines;
    }

    public String attributeTypeString(StardocOutputProtos.AttributeInfo attrInfo) {
        String typeLink;
        switch (attrInfo.getType()) {
            case LABEL: 
            case LABEL_LIST: 
            case OUTPUT: {
                typeLink = "https://bazel.build/concepts/labels";
                break;
            }
            case NAME: {
                typeLink = "https://bazel.build/concepts/labels#target-names";
                break;
            }
            case STRING_DICT: 
            case STRING_LIST_DICT: 
            case LABEL_STRING_DICT: {
                typeLink = "https://bazel.build/rules/lib/dict";
                break;
            }
            default: {
                typeLink = null;
            }
        }
        if (typeLink == null) {
            return MarkdownUtil.attributeTypeDescription(attrInfo.getType());
        }
        return String.format("<a href=\"%s\">%s</a>", typeLink, MarkdownUtil.attributeTypeDescription(attrInfo.getType()));
    }

    public String mandatoryString(StardocOutputProtos.AttributeInfo attrInfo) {
        return attrInfo.getMandatory() ? "required" : "optional";
    }

    public String mandatoryString(StardocOutputProtos.FunctionParamInfo paramInfo) {
        return paramInfo.getMandatory() ? "required" : "optional";
    }

    public String attributeProviders(StardocOutputProtos.AttributeInfo attributeInfo) {
        List<StardocOutputProtos.ProviderNameGroup> providerNames = attributeInfo.getProviderNameGroupList();
        ArrayList<String> finalProviderNames = new ArrayList<String>();
        for (StardocOutputProtos.ProviderNameGroup providerNameList : providerNames) {
            ProtocolStringList providers = providerNameList.getProviderNameList();
            finalProviderNames.add(Joiner.on(", ").join(providers));
        }
        return Joiner.on("; or ").join(finalProviderNames);
    }

    private static String attributeTypeDescription(StardocOutputProtos.AttributeType attributeType) {
        switch (attributeType) {
            case NAME: {
                return "Name";
            }
            case INT: {
                return "Integer";
            }
            case STRING: {
                return "String";
            }
            case STRING_LIST: {
                return "List of strings";
            }
            case INT_LIST: {
                return "List of integers";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case LABEL_STRING_DICT: {
                return "Dictionary: Label -> String";
            }
            case STRING_DICT: {
                return "Dictionary: String -> String";
            }
            case STRING_LIST_DICT: {
                return "Dictionary: String -> List of strings";
            }
            case LABEL: 
            case OUTPUT: {
                return "Label";
            }
            case LABEL_LIST: 
            case OUTPUT_LIST: {
                return "List of labels";
            }
            case UNKNOWN: 
            case UNRECOGNIZED: {
                throw new IllegalArgumentException("Unhandled type " + attributeType);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + attributeType);
    }
}

