/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.rendering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.build.skydoc.rendering.DocstringParseException;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import com.google.devtools.starlark.common.DocstringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkFunction;

public final class FunctionUtil {
    public static StardocOutputProtos.StarlarkFunctionInfo fromNameAndFunction(String functionName, StarlarkFunction fn) throws DocstringParseException {
        Object functionDescription = "";
        LinkedHashMap<String, String> paramNameToDocMap = Maps.newLinkedHashMap();
        StardocOutputProtos.FunctionReturnInfo retInfo = StardocOutputProtos.FunctionReturnInfo.getDefaultInstance();
        StardocOutputProtos.FunctionDeprecationInfo deprInfo = StardocOutputProtos.FunctionDeprecationInfo.getDefaultInstance();
        String doc = fn.getDocumentation();
        if (doc != null) {
            ArrayList<DocstringUtils.DocstringParseError> parseErrors = Lists.newArrayList();
            DocstringUtils.DocstringInfo docstringInfo = DocstringUtils.parseDocstring(doc, parseErrors);
            if (!parseErrors.isEmpty()) {
                throw new DocstringParseException(functionName, fn.getLocation(), parseErrors);
            }
            functionDescription = (String)functionDescription + docstringInfo.getSummary();
            if (!docstringInfo.getSummary().isEmpty() && !docstringInfo.getLongDescription().isEmpty()) {
                functionDescription = (String)functionDescription + "\n\n";
            }
            functionDescription = (String)functionDescription + docstringInfo.getLongDescription();
            for (DocstringUtils.ParameterDoc paramDoc : docstringInfo.getParameters()) {
                paramNameToDocMap.put(paramDoc.getParameterName(), paramDoc.getDescription());
            }
            retInfo = FunctionUtil.returnInfo(docstringInfo);
            deprInfo = FunctionUtil.deprecationInfo(docstringInfo);
        }
        List<StardocOutputProtos.FunctionParamInfo> paramsInfo = FunctionUtil.parameterInfos(fn, paramNameToDocMap);
        return StardocOutputProtos.StarlarkFunctionInfo.newBuilder().setFunctionName(functionName).setDocString((String)functionDescription).addAllParameter(paramsInfo).setReturn(retInfo).setDeprecated(deprInfo).build();
    }

    public static StardocOutputProtos.FunctionParamInfo forParam(String name, String docString, @Nullable Object defaultValue) {
        StardocOutputProtos.FunctionParamInfo.Builder paramBuilder = StardocOutputProtos.FunctionParamInfo.newBuilder().setName(name).setDocString(docString);
        if (defaultValue == null) {
            paramBuilder.setMandatory(true);
        } else {
            paramBuilder.setDefaultValue(Starlark.repr(defaultValue)).setMandatory(false);
        }
        return paramBuilder.build();
    }

    public static StardocOutputProtos.FunctionParamInfo forSpecialParam(String name, String docString) {
        return StardocOutputProtos.FunctionParamInfo.newBuilder().setName(name).setDocString(docString).setMandatory(false).build();
    }

    private static List<StardocOutputProtos.FunctionParamInfo> parameterInfos(StarlarkFunction fn, Map<String, String> parameterDoc) {
        ImmutableList<String> names = fn.getParameterNames();
        int nparams = names.size();
        int kwargsIndex = fn.hasKwargs() ? --nparams : -1;
        int varargsIndex = fn.hasVarargs() ? --nparams : -1;
        ImmutableList.Builder infos = ImmutableList.builder();
        for (int i = 0; i < names.size(); ++i) {
            StardocOutputProtos.FunctionParamInfo info;
            String doc;
            String name = (String)names.get(i);
            if (i == varargsIndex) {
                doc = parameterDoc.getOrDefault("*" + name, "");
                info = FunctionUtil.forSpecialParam(name, doc);
            } else if (i == kwargsIndex) {
                doc = parameterDoc.getOrDefault("**" + name, "");
                info = FunctionUtil.forSpecialParam(name, doc);
            } else {
                doc = parameterDoc.getOrDefault(name, "");
                info = FunctionUtil.forParam(name, doc, fn.getDefaultValue(i));
            }
            infos.add(info);
        }
        return infos.build();
    }

    private static StardocOutputProtos.FunctionReturnInfo returnInfo(DocstringUtils.DocstringInfo docstringInfo) {
        return StardocOutputProtos.FunctionReturnInfo.newBuilder().setDocString(docstringInfo.getReturns()).build();
    }

    private static StardocOutputProtos.FunctionDeprecationInfo deprecationInfo(DocstringUtils.DocstringInfo docstringInfo) {
        return StardocOutputProtos.FunctionDeprecationInfo.newBuilder().setDocString(docstringInfo.getDeprecated()).build();
    }
}

