/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.rendering;

import com.google.devtools.starlark.common.DocstringUtils;
import java.util.List;
import net.starlark.java.syntax.Location;

public class DocstringParseException
extends Exception {
    public DocstringParseException(String functionName, Location definedLocation, List<DocstringUtils.DocstringParseError> parseErrors) {
        super(DocstringParseException.getMessage(functionName, definedLocation, parseErrors));
    }

    private static String getMessage(String functionName, Location definedLocation, List<DocstringUtils.DocstringParseError> parseErrors) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("Unable to generate documentation for function %s (defined at %s) due to malformed docstring. Parse errors:\n", functionName, definedLocation));
        for (DocstringUtils.DocstringParseError parseError : parseErrors) {
            message.append(String.format("  %s line %s: %s\n", definedLocation, parseError.getLineNumber(), parseError.getMessage().replace('\n', ' ')));
        }
        return message.toString();
    }
}

