/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.renderer;

import com.google.devtools.build.skydoc.renderer.RendererOptions;
import com.google.devtools.build.skydoc.rendering.MarkdownRenderer;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import com.google.devtools.common.options.OptionsParser;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class RendererMain {
    public static void main(String[] args) throws IOException {
        OptionsParser parser = OptionsParser.builder().optionsClasses(RendererOptions.class).build();
        parser.parseAndExitUponError(args);
        RendererOptions rendererOptions = parser.getOptions(RendererOptions.class);
        if (rendererOptions.inputPath.isEmpty() || rendererOptions.outputFilePath.isEmpty()) {
            throw new IllegalArgumentException("Both --input and --output must be specified. Usage: {renderer_bin} --input=\"{input_proto_file}\" --output=\"{output_file}\"");
        }
        String inputPath = rendererOptions.inputPath;
        String outputPath = rendererOptions.outputFilePath;
        if (rendererOptions.headerTemplateFilePath.isEmpty() || rendererOptions.ruleTemplateFilePath.isEmpty() || rendererOptions.providerTemplateFilePath.isEmpty() || rendererOptions.funcTemplateFilePath.isEmpty() || rendererOptions.aspectTemplateFilePath.isEmpty()) {
            throw new FileNotFoundException("Input templates --header_template --func_template --provider_template --rule_template --aspect_template must be specified.");
        }
        String headerTemplatePath = rendererOptions.headerTemplateFilePath;
        String ruleTemplatePath = rendererOptions.ruleTemplateFilePath;
        String providerTemplatePath = rendererOptions.providerTemplateFilePath;
        String funcTemplatePath = rendererOptions.funcTemplateFilePath;
        String aspectTemplatePath = rendererOptions.aspectTemplateFilePath;
        MarkdownRenderer renderer = new MarkdownRenderer(headerTemplatePath, ruleTemplatePath, providerTemplatePath, funcTemplatePath, aspectTemplatePath);
        try (PrintWriter printWriter = new PrintWriter(outputPath, StandardCharsets.UTF_8){

            @Override
            public void println() {
                this.write("\n");
            }
        };){
            StardocOutputProtos.ModuleInfo moduleInfo = StardocOutputProtos.ModuleInfo.parseFrom(new FileInputStream(inputPath));
            printWriter.println(renderer.renderMarkdownHeader(moduleInfo));
            RendererMain.printRuleInfos(printWriter, renderer, moduleInfo.getRuleInfoList());
            RendererMain.printProviderInfos(printWriter, renderer, moduleInfo.getProviderInfoList());
            RendererMain.printStarlarkFunctions(printWriter, renderer, moduleInfo.getFuncInfoList());
            RendererMain.printAspectInfos(printWriter, renderer, moduleInfo.getAspectInfoList());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Input file is not a valid ModuleInfo proto.", e);
        }
    }

    private static void printRuleInfos(PrintWriter printWriter, MarkdownRenderer renderer, List<StardocOutputProtos.RuleInfo> ruleInfos) throws IOException {
        for (StardocOutputProtos.RuleInfo ruleProto : ruleInfos) {
            printWriter.println(renderer.render(ruleProto.getRuleName(), ruleProto));
            printWriter.println();
        }
    }

    private static void printProviderInfos(PrintWriter printWriter, MarkdownRenderer renderer, List<StardocOutputProtos.ProviderInfo> providerInfos) throws IOException {
        for (StardocOutputProtos.ProviderInfo providerProto : providerInfos) {
            printWriter.println(renderer.render(providerProto.getProviderName(), providerProto));
            printWriter.println();
        }
    }

    private static void printStarlarkFunctions(PrintWriter printWriter, MarkdownRenderer renderer, List<StardocOutputProtos.StarlarkFunctionInfo> userDefinedFunctions) throws IOException {
        for (StardocOutputProtos.StarlarkFunctionInfo funcProto : userDefinedFunctions) {
            printWriter.println(renderer.render(funcProto));
            printWriter.println();
        }
    }

    private static void printAspectInfos(PrintWriter printWriter, MarkdownRenderer renderer, List<StardocOutputProtos.AspectInfo> aspectInfos) throws IOException {
        for (StardocOutputProtos.AspectInfo aspectProto : aspectInfos) {
            printWriter.println(renderer.render(aspectProto.getAspectName(), aspectProto));
            printWriter.println();
        }
    }
}

