/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.renderer;

import com.google.devtools.build.skydoc.renderer.ProtoFileAccessor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileSystemAccessor
implements ProtoFileAccessor {
    @Override
    public byte[] getProtoContent(String inputPathString) throws IOException {
        Path inputPath = Paths.get(inputPathString, new String[0]);
        byte[] inputContent = Files.readAllBytes(inputPath);
        return inputContent;
    }

    @Override
    public boolean fileExists(String pathString) {
        return Files.exists(Paths.get(pathString, new String[0]), new LinkOption[0]);
    }

    @Override
    public void writeToOutputLocation(String outputPathString, byte[] content) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(outputPathString);){
            for (byte byteContent : content) {
                outputStream.write(byteContent);
            }
        }
    }
}

