/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import com.google.testing.coverage.BranchExp;
import com.google.testing.coverage.CovExp;
import com.google.testing.coverage.ProbeExp;
import com.google.testing.coverage.jarjar.org.objectweb.asm.Handle;
import com.google.testing.coverage.jarjar.org.objectweb.asm.Label;
import com.google.testing.coverage.jarjar.org.objectweb.asm.MethodVisitor;
import com.google.testing.coverage.jarjar.org.objectweb.asm.tree.AbstractInsnNode;
import com.google.testing.coverage.jarjar.org.objectweb.asm.tree.MethodNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jacoco.core.internal.analysis.Instruction;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.flow.IFrame;
import org.jacoco.core.internal.flow.LabelInfo;
import org.jacoco.core.internal.flow.MethodProbesVisitor;

public class MethodProbesMapper
extends MethodProbesVisitor
implements IFilterOutput {
    private Instruction lastInstruction = null;
    private int currentLine = -1;
    private List<Label> currentLabels = new ArrayList<Label>();
    private AbstractInsnNode currentInstructionNode = null;
    private Map<AbstractInsnNode, Instruction> instructionMap = new HashMap<AbstractInsnNode, Instruction>();
    private int instructionNodeIndex = 0;
    private Map<AbstractInsnNode, Integer> instructionNodeIndexMap = new HashMap<AbstractInsnNode, Integer>();
    private IFilter filter;
    private IFilterContext filterContext;
    private HashSet<AbstractInsnNode> ignored = new HashSet();
    private Map<AbstractInsnNode, AbstractInsnNode> unioned = new HashMap<AbstractInsnNode, AbstractInsnNode>();
    private Map<AbstractInsnNode, Set<AbstractInsnNode>> branchReplacements = new HashMap<AbstractInsnNode, Set<AbstractInsnNode>>();
    private Map<Integer, BranchExp> lineToBranchExp = new TreeMap<Integer, BranchExp>();
    private List<Instruction> instructions = new ArrayList<Instruction>();
    private List<Jump> jumps = new ArrayList<Jump>();
    private Map<Integer, Instruction> probeToInsn = new TreeMap<Integer, Instruction>();
    private final Map<Instruction, CovExp> insnToCovExp = new HashMap<Instruction, CovExp>();
    private final Map<Instruction, Integer> insnToIdx = new HashMap<Instruction, Integer>();
    private Map<Instruction, Instruction> predecessors = new HashMap<Instruction, Instruction>();
    private Map<Label, Instruction> labelToInsn = new HashMap<Label, Instruction>();

    public Map<Integer, BranchExp> result() {
        return this.lineToBranchExp;
    }

    public MethodProbesMapper(IFilterContext filterContext, IFilter filter) {
        this.filterContext = filterContext;
        this.filter = filter;
    }

    @Override
    public void accept(MethodNode methodNode, MethodVisitor methodVisitor) {
        methodVisitor.visitCode();
        Iterator iterator = methodNode.instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode i;
            this.currentInstructionNode = i = (AbstractInsnNode)iterator.next();
            i.accept(methodVisitor);
        }
        this.filter.filter(methodNode, this.filterContext, this);
        methodVisitor.visitEnd();
    }

    private void visitInsn() {
        Instruction instruction = new Instruction(this.currentLine);
        this.instructions.add(instruction);
        if (this.lastInstruction != null) {
            this.lastInstruction.addBranch(instruction, 0);
            this.predecessors.put(instruction, this.lastInstruction);
        }
        for (Label label : this.currentLabels) {
            this.labelToInsn.put(label, instruction);
        }
        this.currentLabels.clear();
        this.lastInstruction = instruction;
        this.instructionMap.put(this.currentInstructionNode, instruction);
        this.instructionNodeIndexMap.put(this.currentInstructionNode, this.instructionNodeIndex);
        ++this.instructionNodeIndex;
    }

    @Override
    public void visitInsn(int opcode) {
        this.visitInsn();
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.visitInsn();
    }

    @Override
    public void visitVarInsn(int opcode, int variable) {
        this.visitInsn();
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.visitInsn();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.visitInsn();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.visitInsn();
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle handle, Object ... args) {
        this.visitInsn();
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.visitInsn();
    }

    @Override
    public void visitIincInsn(int var, int inc) {
        this.visitInsn();
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.visitInsn();
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.visitInsn();
        this.jumps.add(new Jump(this.lastInstruction, label, 1));
    }

    @Override
    public void visitLabel(Label label) {
        this.currentLabels.add(label);
        if (!LabelInfo.isSuccessor(label)) {
            this.lastInstruction = null;
        }
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.currentLine = line;
    }

    private void visitSwitchInsn(Label dflt, Label[] labels) {
        this.visitInsn();
        LabelInfo.resetDone(dflt);
        int branch = 0;
        this.jumps.add(new Jump(this.lastInstruction, dflt, branch));
        LabelInfo.setDone(dflt);
        LabelInfo.resetDone(labels);
        for (Label label : labels) {
            if (LabelInfo.isDone(label)) continue;
            this.jumps.add(new Jump(this.lastInstruction, label, branch));
            LabelInfo.setDone(label);
        }
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    private void addProbe(int probeId) {
        this.lastInstruction.addBranch(false, 0);
        this.probeToInsn.put(probeId, this.lastInstruction);
    }

    @Override
    public void visitProbe(int probeId) {
        assert (this.lastInstruction != null);
        this.addProbe(probeId);
        this.lastInstruction = null;
    }

    @Override
    public void visitJumpInsnWithProbe(int opcode, Label label, int probeId, IFrame frame) {
        this.visitInsn();
        this.addProbe(probeId);
    }

    @Override
    public void visitInsnWithProbe(int opcode, int probeId) {
        this.visitInsn();
        this.addProbe(probeId);
    }

    @Override
    public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels, IFrame frame) {
        this.visitSwitchInsnWithProbes(dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels, IFrame frame) {
        this.visitSwitchInsnWithProbes(dflt, labels);
    }

    private void visitSwitchInsnWithProbes(Label dflt, Label[] labels) {
        this.visitInsn();
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        int branch = 0;
        this.visitTargetWithProbe(dflt, branch);
        for (Label l : labels) {
            this.visitTargetWithProbe(l, branch);
        }
    }

    private void visitTargetWithProbe(Label label, int branch) {
        if (!LabelInfo.isDone(label)) {
            int id = LabelInfo.getProbeId(label);
            if (id == -1) {
                this.jumps.add(new Jump(this.lastInstruction, label, branch));
            } else {
                this.addProbe(id);
            }
            LabelInfo.setDone(label);
        }
    }

    private BranchExp getPredBranchExp(Instruction predecessor) {
        BranchExp result = null;
        CovExp exp = this.insnToCovExp.get(predecessor);
        if (exp instanceof ProbeExp) {
            result = new BranchExp(exp);
            this.insnToCovExp.put(predecessor, result);
        } else {
            result = (BranchExp)exp;
        }
        return result;
    }

    private boolean updateBranchPredecessor(Instruction predecessor, Instruction insn, CovExp exp) {
        CovExp predExp = this.insnToCovExp.get(predecessor);
        if (predExp == null) {
            BranchExp branchExp = new BranchExp(exp);
            this.insnToCovExp.put(predecessor, branchExp);
            this.insnToIdx.put(insn, 0);
            return true;
        }
        BranchExp branchExp = this.getPredBranchExp(predecessor);
        Integer branchIdx = this.insnToIdx.get(insn);
        if (branchIdx == null) {
            branchIdx = branchExp.add(exp);
            this.insnToIdx.put(insn, branchIdx);
        }
        return false;
    }

    @Override
    public void visitEnd() {
        for (Jump jump : this.jumps) {
            Instruction insn = this.labelToInsn.get(jump.target);
            jump.source.addBranch(insn, jump.branch);
            this.predecessors.put(insn, jump.source);
        }
        block1: for (Map.Entry entry : this.probeToInsn.entrySet()) {
            Instruction ins;
            int probeId = (Integer)entry.getKey();
            Instruction insn = ins = (Instruction)entry.getValue();
            CovExp exp = new ProbeExp(probeId);
            CovExp existingExp = this.insnToCovExp.get(insn);
            if (existingExp != null) {
                if (existingExp instanceof BranchExp) {
                    BranchExp branchExp = (BranchExp)existingExp;
                    branchExp.add(exp);
                }
            } else {
                if (insn.getBranchCounter().getTotalCount() > 1) {
                    exp = new BranchExp(exp);
                }
                this.insnToCovExp.put(insn, exp);
            }
            Instruction predecessor = this.predecessors.get(insn);
            while (predecessor != null) {
                if (predecessor.getBranchCounter().getTotalCount() > 1) {
                    boolean isNewBranch = this.updateBranchPredecessor(predecessor, insn, exp);
                    if (!isNewBranch) {
                        continue block1;
                    }
                } else {
                    this.insnToCovExp.put(predecessor, exp);
                }
                insn = predecessor;
                exp = this.insnToCovExp.get(predecessor);
                predecessor = this.predecessors.get(insn);
            }
        }
        for (AbstractInsnNode abstractInsnNode : this.unioned.keySet()) {
            AbstractInsnNode rep = this.findRepresentative(abstractInsnNode);
            Instruction insn = this.instructionMap.get(abstractInsnNode);
            Instruction repInsn = this.instructionMap.get(rep);
            BranchExp branch = BranchExp.ensureIsBranchExp(this.insnToCovExp.get(insn));
            BranchExp repBranch = BranchExp.ensureIsBranchExp(this.insnToCovExp.get(repInsn));
            this.insnToCovExp.put(repInsn, BranchExp.zip(repBranch, branch));
            this.ignored.add(abstractInsnNode);
        }
        for (Map.Entry entry : this.branchReplacements.entrySet()) {
            ArrayList<AbstractInsnNode> replacements = new ArrayList<AbstractInsnNode>((Collection)entry.getValue());
            replacements.sort(Comparator.comparing(this.instructionNodeIndexMap::get));
            BranchExp newBranch = new BranchExp(new ArrayList<CovExp>());
            for (AbstractInsnNode node : replacements) {
                newBranch.add(this.insnToCovExp.get(this.instructionMap.get(node)));
            }
            this.insnToCovExp.put(this.instructionMap.get(entry.getKey()), newBranch);
        }
        HashSet<Instruction> ignoredInstructions = new HashSet<Instruction>();
        for (Map.Entry<AbstractInsnNode, Instruction> entry : this.instructionMap.entrySet()) {
            if (!this.ignored.contains(entry.getKey())) continue;
            ignoredInstructions.add(entry.getValue());
        }
        for (Instruction insn : this.instructions) {
            CovExp insnExp;
            if (ignoredInstructions.contains(insn) || insn.getBranchCounter().getTotalCount() <= 1 || (insnExp = this.insnToCovExp.get(insn)) == null || !(insnExp instanceof BranchExp)) continue;
            BranchExp exp = (BranchExp)insnExp;
            BranchExp lineExp = this.lineToBranchExp.get(insn.getLine());
            if (lineExp == null) {
                this.lineToBranchExp.put(insn.getLine(), exp);
                continue;
            }
            this.lineToBranchExp.put(insn.getLine(), BranchExp.concatenate(lineExp, exp));
        }
    }

    @Override
    public void ignore(AbstractInsnNode fromInclusive, AbstractInsnNode toInclusive) {
        for (AbstractInsnNode n = fromInclusive; n != toInclusive; n = n.getNext()) {
            this.ignored.add(n);
        }
        this.ignored.add(toInclusive);
    }

    @Override
    public void merge(AbstractInsnNode i1, AbstractInsnNode i2) {
        if ((i1 = this.findRepresentative(i1)) != (i2 = this.findRepresentative(i2))) {
            this.unioned.put(i1, i2);
        }
    }

    @Override
    public void replaceBranches(AbstractInsnNode source, Set<AbstractInsnNode> newTargets) {
        this.branchReplacements.put(source, newTargets);
    }

    private AbstractInsnNode findRepresentative(AbstractInsnNode node) {
        AbstractInsnNode parent;
        while ((parent = this.unioned.get(node)) != null) {
            AbstractInsnNode grandParent = this.unioned.get(parent);
            if (grandParent != null) {
                this.unioned.put(node, grandParent);
            }
            node = parent;
        }
        return node;
    }

    class Jump {
        public final Instruction source;
        public final Label target;
        public final int branch;

        public Jump(Instruction i, Label l, int b) {
            this.source = i;
            this.target = l;
            this.branch = b;
        }
    }
}

