/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import com.google.testing.coverage.BranchCoverageDetail;
import com.google.testing.coverage.jarjar.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;

public class JacocoLCOVFormatter {
    private final Optional<ImmutableSet<String>> execPathsOfUninstrumentedFiles;
    private static final String EXEC_PATH_DELIMITER = "///";

    public JacocoLCOVFormatter(ImmutableSet<String> execPathsOfUninstrumentedFiles) {
        this.execPathsOfUninstrumentedFiles = Optional.of(execPathsOfUninstrumentedFiles);
    }

    public JacocoLCOVFormatter() {
        this.execPathsOfUninstrumentedFiles = Optional.empty();
    }

    public IReportVisitor createVisitor(final PrintWriter output, final Map<String, BranchCoverageDetail> branchCoverageDetail) {
        return new IReportVisitor(){
            private Map<String, Map<String, IClassCoverage>> sourceToClassCoverage = new TreeMap<String, Map<String, IClassCoverage>>();
            private Map<String, ISourceFileCoverage> sourceToFileCoverage = new TreeMap<String, ISourceFileCoverage>();

            private String getExecPathForEntryName(String classPath) {
                if (!JacocoLCOVFormatter.this.execPathsOfUninstrumentedFiles.isPresent()) {
                    return classPath;
                }
                String matchingFileName = classPath.startsWith("/") ? classPath : "/" + classPath;
                for (String execPath : (ImmutableSet)JacocoLCOVFormatter.this.execPathsOfUninstrumentedFiles.get()) {
                    if (execPath.contains(JacocoLCOVFormatter.EXEC_PATH_DELIMITER)) {
                        String[] parts = execPath.split(JacocoLCOVFormatter.EXEC_PATH_DELIMITER, 2);
                        if (parts.length != 2 || !parts[1].equals(matchingFileName)) continue;
                        return parts[0];
                    }
                    if (!execPath.endsWith(matchingFileName) && !execPath.equals(classPath)) continue;
                    return execPath;
                }
                return null;
            }

            @Override
            public void visitInfo(List<SessionInfo> sessionInfos, Collection<ExecutionData> executionData) throws IOException {
            }

            @Override
            public void visitEnd() throws IOException {
                for (String sourceFile : this.sourceToClassCoverage.keySet()) {
                    this.processSourceFile(output, sourceFile);
                }
            }

            @Override
            public void visitBundle(IBundleCoverage bundle, ISourceFileLocator locator) throws IOException {
                for (IPackageCoverage pkgCoverage : bundle.getPackages()) {
                    for (IClassCoverage clsCoverage : pkgCoverage.getClasses()) {
                        String fileName = this.getExecPathForEntryName(clsCoverage.getPackageName() + "/" + clsCoverage.getSourceFileName());
                        if (fileName == null) continue;
                        if (!this.sourceToClassCoverage.containsKey(fileName)) {
                            this.sourceToClassCoverage.put(fileName, new TreeMap());
                        }
                        this.sourceToClassCoverage.get(fileName).put(clsCoverage.getName(), clsCoverage);
                    }
                    for (ISourceFileCoverage srcCoverage : pkgCoverage.getSourceFiles()) {
                        String sourceName = this.getExecPathForEntryName(srcCoverage.getPackageName() + "/" + srcCoverage.getName());
                        if (sourceName == null) continue;
                        this.sourceToFileCoverage.put(sourceName, srcCoverage);
                    }
                }
            }

            @Override
            public IReportGroupVisitor visitGroup(String name) throws IOException {
                return null;
            }

            private void processSourceFile(PrintWriter writer, String sourceFile) {
                writer.printf("SF:%s\n", sourceFile);
                ISourceFileCoverage srcCoverage = this.sourceToFileCoverage.get(sourceFile);
                if (srcCoverage != null) {
                    for (IClassCoverage clsCoverage : this.sourceToClassCoverage.get(sourceFile).values()) {
                        for (IMethodCoverage iMethodCoverage : clsCoverage.getMethods()) {
                            String name = this.constructFunctionName(iMethodCoverage, clsCoverage.getName());
                            writer.printf("FN:%d,%s\n", iMethodCoverage.getFirstLine(), name);
                            writer.printf("FNDA:%d,%s\n", iMethodCoverage.getMethodCounter().getCoveredCount(), name);
                        }
                    }
                    for (IClassCoverage clsCoverage : this.sourceToClassCoverage.get(sourceFile).values()) {
                        BranchCoverageDetail detail = (BranchCoverageDetail)branchCoverageDetail.get(clsCoverage.getName());
                        if (detail == null) continue;
                        for (int line : detail.linesWithBranches()) {
                            int branchIdx;
                            int numBranches = detail.getBranches(line);
                            boolean executed = detail.getExecutedBit(line);
                            if (executed) {
                                for (branchIdx = 0; branchIdx < numBranches; ++branchIdx) {
                                    if (detail.getTakenBit(line, branchIdx)) {
                                        writer.printf("BRDA:%d,%d,%d,%d\n", line, 0, branchIdx, 1);
                                        continue;
                                    }
                                    writer.printf("BRDA:%d,%d,%d,%d\n", line, 0, branchIdx, 0);
                                }
                                continue;
                            }
                            for (branchIdx = 0; branchIdx < numBranches; ++branchIdx) {
                                writer.printf("BRDA:%d,%d,%d,%s\n", line, 0, branchIdx, "-");
                            }
                        }
                    }
                    int firstLine = srcCoverage.getFirstLine();
                    int lastLine = srcCoverage.getLastLine();
                    for (int line = firstLine; line <= lastLine; ++line) {
                        ICounter iCounter = srcCoverage.getLine(line).getInstructionCounter();
                        if (iCounter.getTotalCount() == 0) continue;
                        int execCount = iCounter.getCoveredCount() > 0 ? 1 : 0;
                        writer.printf("DA:%d,%d\n", line, execCount);
                    }
                }
                writer.println("end_of_record");
            }

            private String constructFunctionName(IMethodCoverage mthCoverage, String clsName) {
                return clsName + "::" + mthCoverage.getName() + " " + mthCoverage.getDesc();
            }
        };
    }
}

