/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import com.google.testing.coverage.BranchCoverageDetail;
import com.google.testing.coverage.BranchDetailAnalyzer;
import com.google.testing.coverage.JacocoLCOVFormatter;
import com.google.testing.coverage.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.testing.coverage.jarjar.com.google.common.collect.ImmutableCollection;
import com.google.testing.coverage.jarjar.com.google.common.collect.ImmutableList;
import com.google.testing.coverage.jarjar.com.google.common.collect.ImmutableSet;
import com.google.testing.coverage.jarjar.com.google.common.io.ByteStreams;
import com.google.testing.coverage.jarjar.com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jacoco.agent.rt.IAgent;
import org.jacoco.agent.rt.RT;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import sun.misc.Unsafe;

public class JacocoCoverageRunner {
    private final ImmutableList<File> classesJars;
    private final InputStream executionData;
    private final File reportFile;
    private ExecFileLoader execFileLoader;
    private HashMap<String, byte[]> uninstrumentedClasses;
    private ImmutableSet<String> pathsForCoverage = ImmutableSet.of();

    public JacocoCoverageRunner(InputStream jacocoExec, String reportPath, File wrapperFile, String javaRunfilesRoot) throws IOException {
        this.executionData = jacocoExec;
        this.reportFile = new File(reportPath);
        this.classesJars = JacocoCoverageRunner.getFilesFromFileList(wrapperFile, javaRunfilesRoot);
    }

    public JacocoCoverageRunner(InputStream jacocoExec, String reportPath, File ... metadataJars) {
        this.executionData = jacocoExec;
        this.reportFile = new File(reportPath);
        this.classesJars = ImmutableList.copyOf(metadataJars);
    }

    public JacocoCoverageRunner(InputStream jacocoExec, String reportPath, HashMap<String, byte[]> uninstrumentedClasses, ImmutableSet<String> pathsForCoverage, File ... metadataJars) {
        this.executionData = jacocoExec;
        this.reportFile = new File(reportPath);
        this.classesJars = ImmutableList.copyOf(metadataJars);
        this.uninstrumentedClasses = uninstrumentedClasses;
        this.pathsForCoverage = pathsForCoverage;
    }

    public void create() throws IOException {
        this.execFileLoader = new ExecFileLoader();
        this.execFileLoader.load(this.executionData);
        IBundleCoverage bundleCoverage = this.analyzeStructure();
        Map<String, BranchCoverageDetail> branchDetails = this.analyzeBranch();
        this.createReport(bundleCoverage, branchDetails);
    }

    @VisibleForTesting
    void createReport(IBundleCoverage bundleCoverage, Map<String, BranchCoverageDetail> branchDetails) throws IOException {
        JacocoLCOVFormatter formatter = new JacocoLCOVFormatter(this.createPathsSet());
        try (PrintWriter writer = new PrintWriter(java.nio.file.Files.newBufferedWriter(this.reportFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND));){
            IReportVisitor visitor = formatter.createVisitor(writer, branchDetails);
            visitor.visitInfo(this.execFileLoader.getSessionInfoStore().getInfos(), this.execFileLoader.getExecutionDataStore().getContents());
            visitor.visitBundle(bundleCoverage, new ISourceFileLocator(){

                @Override
                public Reader getSourceFile(String packageName, String fileName) throws IOException {
                    return null;
                }

                @Override
                public int getTabWidth() {
                    return 0;
                }
            });
            visitor.visitEnd();
        }
    }

    @VisibleForTesting
    IBundleCoverage analyzeStructure() throws IOException {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.execFileLoader.getExecutionDataStore(), coverageBuilder);
        HashSet<String> alreadyInstrumentedClasses = new HashSet<String>();
        if (this.uninstrumentedClasses == null) {
            for (File classesJar : this.classesJars) {
                this.analyzeUninstrumentedClassesFromJar(analyzer, classesJar, alreadyInstrumentedClasses);
            }
        } else {
            for (Map.Entry<String, byte[]> entry : this.uninstrumentedClasses.entrySet()) {
                analyzer.analyzeClass(entry.getValue(), entry.getKey());
            }
        }
        return coverageBuilder.getBundle("isthisevenused");
    }

    private Map<String, BranchCoverageDetail> analyzeBranch() throws IOException {
        BranchDetailAnalyzer analyzer = new BranchDetailAnalyzer(this.execFileLoader.getExecutionDataStore());
        TreeMap<String, BranchCoverageDetail> result = new TreeMap<String, BranchCoverageDetail>();
        HashSet<String> alreadyInstrumentedClasses = new HashSet<String>();
        if (this.uninstrumentedClasses == null) {
            for (File classesJar : this.classesJars) {
                this.analyzeUninstrumentedClassesFromJar(analyzer, classesJar, alreadyInstrumentedClasses);
                result.putAll(analyzer.getBranchDetails());
            }
        } else {
            for (Map.Entry<String, byte[]> entry : this.uninstrumentedClasses.entrySet()) {
                analyzer.analyzeClass(entry.getValue(), entry.getKey());
            }
            result.putAll(analyzer.getBranchDetails());
        }
        return result;
    }

    private void analyzeUninstrumentedClassesFromJar(Analyzer analyzer, File jar, Set<String> alreadyInstrumentedClasses) throws IOException {
        JarFile jarFile = new JarFile(jar);
        Enumeration<JarEntry> jarFileEntries = jarFile.entries();
        while (jarFileEntries.hasMoreElements()) {
            JarEntry jarEntry = jarFileEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith(".class.uninstrumented") || alreadyInstrumentedClasses.contains(jarEntryName)) continue;
            analyzer.analyzeAll(jarFile.getInputStream(jarEntry), jarEntryName);
            alreadyInstrumentedClasses.add(jarEntryName);
        }
    }

    @VisibleForTesting
    ImmutableSet<String> createPathsSet() throws IOException {
        if (!this.pathsForCoverage.isEmpty()) {
            return this.pathsForCoverage;
        }
        ImmutableSet.Builder<String> execPathsSetBuilder = ImmutableSet.builder();
        for (File classJar : this.classesJars) {
            JacocoCoverageRunner.addEntriesToExecPathsSet(classJar, execPathsSetBuilder);
        }
        ImmutableCollection result = execPathsSetBuilder.build();
        return result;
    }

    @VisibleForTesting
    static void addEntriesToExecPathsSet(File jar, ImmutableSet.Builder<String> execPathsSetBuilder) throws IOException {
        JarFile jarFile = new JarFile(jar);
        Enumeration<JarEntry> jarFileEntries = jarFile.entries();
        while (jarFileEntries.hasMoreElements()) {
            String line;
            JarEntry jarEntry = jarFileEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith("-paths-for-coverage.txt")) continue;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry), StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                execPathsSetBuilder.add((Object)line);
            }
        }
    }

    private static Class<?> getMainClass(boolean insideDeployJar) throws Exception {
        String jacocoMainClass;
        if (insideDeployJar && JacocoCoverageRunner.class.getClassLoader() != null) {
            Enumeration<URL> manifests = JacocoCoverageRunner.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                Manifest manifest = new Manifest(manifests.nextElement().openStream());
                Attributes attributes = manifest.getMainAttributes();
                String className = attributes.getValue("Coverage-Main-Class");
                if (className == null) continue;
                try {
                    Class<?> mainClass = Class.forName(className);
                    return mainClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if ((jacocoMainClass = System.getenv("JACOCO_MAIN_CLASS")) != null) {
            return Class.forName(jacocoMainClass);
        }
        throw new IllegalStateException("JACOCO_METADATA_JAR/JACOCO_MAIN_CLASS environment variables not set, and no META-INF/MANIFEST.MF on the classpath has a Coverage-Main-Class attribute.  Cannot determine the name of the main class for the code under test.");
    }

    private static String getUniquePath(String pathTemplate, String suffix) throws IOException {
        if (pathTemplate == null) {
            return File.createTempFile("coverage", suffix).getPath();
        }
        File absolutePathTemplate = new File(pathTemplate).getAbsoluteFile();
        String prefix = absolutePathTemplate.getName();
        int lastDot = prefix.lastIndexOf(46);
        if (lastDot != -1) {
            prefix = prefix.substring(0, lastDot);
        }
        return File.createTempFile(prefix, suffix, absolutePathTemplate.getParentFile()).getPath();
    }

    private static ImmutableList<File> getFilesFromFileList(File mainFile, String javaRunfilesRoot) throws IOException {
        List<String> metadataFiles = Files.readLines(mainFile, StandardCharsets.UTF_8);
        ImmutableList.Builder convertedMetadataFiles = new ImmutableList.Builder();
        for (String metadataFile : metadataFiles) {
            convertedMetadataFiles.add(new File(javaRunfilesRoot + "/" + metadataFile));
        }
        return convertedMetadataFiles.build();
    }

    private static URL[] getUrls(ClassLoader classLoader, boolean wasWrappedJar) {
        URL[] urls = JacocoCoverageRunner.getClassLoaderUrls(classLoader);
        if (wasWrappedJar && urls != null && urls.length == 1) {
            try {
                String jarClassPath = new JarInputStream(urls[0].openStream()).getManifest().getMainAttributes().getValue("Class-Path");
                String[] urlStrings = jarClassPath.split(" ");
                URL[] newUrls = new URL[urlStrings.length];
                for (int i = 0; i < urlStrings.length; ++i) {
                    newUrls[i] = new URL(urlStrings[i]);
                }
                return newUrls;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return urls;
    }

    private static URL[] getClassLoaderUrls(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        if (classLoader.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$")) {
            try {
                Field ucpField;
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Unsafe unsafe = (Unsafe)field.get(null);
                try {
                    ucpField = classLoader.getClass().getDeclaredField("ucp");
                }
                catch (NoSuchFieldException e) {
                    ucpField = classLoader.getClass().getSuperclass().getDeclaredField("ucp");
                }
                long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
                Object ucpObject = unsafe.getObject(classLoader, ucpFieldOffset);
                Field pathField = ucpField.getType().getDeclaredField("path");
                long pathFieldOffset = unsafe.objectFieldOffset(pathField);
                ArrayList path = (ArrayList)unsafe.getObject(ucpObject, pathFieldOffset);
                return path.toArray(new URL[path.size()]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String metadataFile = System.getenv("JACOCO_METADATA_JAR");
        String jarWrappedValue = System.getenv("JACOCO_IS_JAR_WRAPPED");
        boolean wasWrappedJar = jarWrappedValue != null ? !jarWrappedValue.equals("0") : false;
        File[] metadataFiles = null;
        int deployJars = 0;
        final HashMap<String, byte[]> uninstrumentedClasses = new HashMap<String, byte[]>();
        ImmutableSet.Builder pathsForCoverageBuilder = new ImmutableSet.Builder();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URL[] urls = JacocoCoverageRunner.getUrls(classLoader, wasWrappedJar);
        if (urls != null) {
            metadataFiles = new File[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                String file = URLDecoder.decode(urls[i].getFile(), "UTF-8");
                metadataFiles[i] = new File(file);
                if (file.endsWith("_deploy.jar")) {
                    metadataFile = file;
                    ++deployJars;
                }
                if (!file.endsWith(".jar")) continue;
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> jarFileEntries = jarFile.entries();
                while (jarFileEntries.hasMoreElements()) {
                    String line;
                    JarEntry jarEntry = jarFileEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (jarEntryName.endsWith(".class.uninstrumented") && !uninstrumentedClasses.containsKey(jarEntryName)) {
                        uninstrumentedClasses.put(jarEntryName, ByteStreams.toByteArray(jarFile.getInputStream(jarEntry)));
                        continue;
                    }
                    if (!jarEntryName.endsWith("-paths-for-coverage.txt")) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry), StandardCharsets.UTF_8));
                    while ((line = bufferedReader.readLine()) != null) {
                        pathsForCoverageBuilder.add(line);
                    }
                }
            }
        }
        ImmutableCollection pathsForCoverage = pathsForCoverageBuilder.build();
        final String metadataFileFinal = metadataFile;
        final File[] metadataFilesFinal = metadataFiles;
        final String javaRunfilesRoot = System.getenv("JACOCO_JAVA_RUNFILES_ROOT");
        boolean hasOneFile = false;
        if (metadataFile != null && (metadataFile.endsWith("_merged_instr.jar") || metadataFile.endsWith("_deploy.jar"))) {
            hasOneFile = true;
        }
        final boolean hasOneFileFinal = hasOneFile;
        final String coverageReportBase = System.getenv("JAVA_COVERAGE_FILE");
        System.setProperty("jacoco-agent.output", "none");
        System.setProperty("jacoco-agent.sessionid", "default");
        Runtime.getRuntime().addShutdownHook(new Thread((ImmutableSet)pathsForCoverage){
            final /* synthetic */ ImmutableSet val$pathsForCoverage;
            {
                this.val$pathsForCoverage = immutableSet;
            }

            @Override
            public void run() {
                try {
                    ByteArrayInputStream dataInputStream;
                    String coverageReport = JacocoCoverageRunner.getUniquePath(coverageReportBase, ".dat");
                    String coverageData = JacocoCoverageRunner.getUniquePath(coverageReportBase, ".exec");
                    try {
                        IAgent agent = RT.getAgent();
                        byte[] data = agent.getExecutionData(false);
                        try (FileOutputStream fs = new FileOutputStream(coverageData, true);){
                            fs.write(data);
                        }
                        dataInputStream = new ByteArrayInputStream(data);
                    }
                    catch (IllegalStateException e) {
                        dataInputStream = new ByteArrayInputStream(new byte[0]);
                    }
                    if (metadataFileFinal != null || metadataFilesFinal != null) {
                        File[] fileArray;
                        File[] metadataJars;
                        if (metadataFilesFinal != null) {
                            metadataJars = metadataFilesFinal;
                        } else if (hasOneFileFinal) {
                            File[] fileArray2 = new File[1];
                            fileArray = fileArray2;
                            fileArray2[0] = new File(metadataFileFinal);
                        } else {
                            fileArray = metadataJars = JacocoCoverageRunner.getFilesFromFileList(new File(metadataFileFinal), javaRunfilesRoot).toArray(new File[0]);
                        }
                        if (uninstrumentedClasses.isEmpty()) {
                            new JacocoCoverageRunner((InputStream)dataInputStream, coverageReport, metadataJars).create();
                        } else {
                            new JacocoCoverageRunner((InputStream)dataInputStream, coverageReport, uninstrumentedClasses, this.val$pathsForCoverage, metadataJars).create();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Runtime.getRuntime().halt(1);
                }
            }
        });
        boolean insideDeployJar = deployJars == 1 && (metadataFilesFinal == null || metadataFilesFinal.length == 1);
        Class<?> mainClass = JacocoCoverageRunner.getMainClass(insideDeployJar);
        Method main = mainClass.getMethod("main", String[].class);
        main.setAccessible(true);
        main.invoke(null, new Object[]{args});
    }
}

