/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import com.google.testing.coverage.BranchExp;
import com.google.testing.coverage.MethodProbesMapper;
import com.google.testing.coverage.jarjar.org.objectweb.asm.AnnotationVisitor;
import com.google.testing.coverage.jarjar.org.objectweb.asm.Attribute;
import com.google.testing.coverage.jarjar.org.objectweb.asm.FieldVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.analysis.filter.Filters;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.flow.MethodProbesVisitor;

public class ClassProbesMapper
extends ClassProbesVisitor
implements IFilterContext {
    private Map<Integer, BranchExp> classLineToBranchExp;
    private IFilter allFilters = Filters.all();
    private StringPool stringPool;
    private String className;
    private String superClassName;
    private Set<String> classAnnotations = new HashSet<String>();
    private Set<String> classAttributes = new HashSet<String>();
    private String sourceFileName;
    private String sourceDebugExtension;

    public Map<Integer, BranchExp> result() {
        return this.classLineToBranchExp;
    }

    public ClassProbesMapper(String className) {
        this.classLineToBranchExp = new TreeMap<Integer, BranchExp>();
        this.stringPool = new StringPool();
        this.className = this.stringPool.get(className);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.classAnnotations.add(desc);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.classAttributes.add(attribute.type);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.sourceFileName = this.stringPool.get(source);
        this.sourceDebugExtension = debug;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superClassName = this.stringPool.get(name);
    }

    @Override
    public MethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodProbesMapper(this, this.allFilters){

            @Override
            public void visitEnd() {
                super.visitEnd();
                ClassProbesMapper.this.classLineToBranchExp.putAll(this.result());
            }
        };
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visitTotalProbeCount(int count) {
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String getSourceDebugExtension() {
        return this.sourceDebugExtension;
    }

    @Override
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Override
    public Set<String> getClassAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public Set<String> getClassAttributes() {
        return this.classAttributes;
    }
}

