/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import com.google.testing.coverage.CovExp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BranchExp
implements CovExp {
    private final List<CovExp> branches;
    private boolean hasValue;
    private boolean[] probesUsed;
    private boolean value;

    public BranchExp(List<CovExp> branches) {
        this.branches = branches;
        this.hasValue = false;
    }

    public BranchExp(CovExp exp) {
        this.branches = new ArrayList<CovExp>();
        this.branches.add(exp);
        this.hasValue = false;
    }

    public List<CovExp> getBranches() {
        return this.branches;
    }

    public int add(CovExp exp) {
        this.branches.add(exp);
        return this.branches.size() - 1;
    }

    public void update(int idx, CovExp exp) {
        this.branches.set(idx, exp);
    }

    public static BranchExp concatenate(BranchExp first, BranchExp second) {
        ArrayList<CovExp> branches = new ArrayList<CovExp>(first.branches);
        branches.addAll(second.branches);
        return new BranchExp(branches);
    }

    public static BranchExp zip(BranchExp left, BranchExp right) {
        List<CovExp> remainder;
        int i;
        ArrayList<CovExp> zippedBranches = new ArrayList<CovExp>();
        int leftSize = left.branches.size();
        int rightSize = right.branches.size();
        for (i = 0; i < leftSize && i < rightSize; ++i) {
            List<CovExp> branches = Arrays.asList(left.branches.get(i), right.branches.get(i));
            zippedBranches.add(new BranchExp(branches));
        }
        List<CovExp> list = remainder = leftSize < rightSize ? right.branches : left.branches;
        while (i < remainder.size()) {
            zippedBranches.add(new BranchExp(remainder.get(i)));
            ++i;
        }
        return new BranchExp(zippedBranches);
    }

    public static BranchExp ensureIsBranchExp(CovExp exp) {
        return exp instanceof BranchExp ? (BranchExp)exp : new BranchExp(exp);
    }

    @Override
    public boolean eval(boolean[] probes) {
        if (this.hasValue && probes == this.probesUsed) {
            return this.value;
        }
        this.value = false;
        for (CovExp exp : this.branches) {
            this.value = exp.eval(probes);
            if (!this.value) continue;
            break;
        }
        this.hasValue = this.value;
        this.probesUsed = probes;
        return this.value;
    }
}

