/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import com.google.testing.coverage.BranchCoverageDetail;
import com.google.testing.coverage.BranchExp;
import com.google.testing.coverage.ClassProbesMapper;
import com.google.testing.coverage.CovExp;
import com.google.testing.coverage.jarjar.org.objectweb.asm.ClassReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.internal.InputStreams;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;

public class BranchDetailAnalyzer
extends Analyzer {
    private final ExecutionDataStore executionData;
    private final Map<String, BranchCoverageDetail> branchDetails;

    public BranchDetailAnalyzer(ExecutionDataStore executionData) {
        super(executionData, new ICoverageVisitor(){

            @Override
            public void visitCoverage(IClassCoverage coverage) {
            }
        });
        this.executionData = executionData;
        this.branchDetails = new TreeMap<String, BranchCoverageDetail>();
    }

    @Override
    public void analyzeClass(InputStream input, String location) throws IOException {
        byte[] buffer;
        try {
            buffer = InputStreams.readFully(input);
        }
        catch (IOException e) {
            throw this.analyzerError(location, e);
        }
        this.analyzeClass(buffer, location);
    }

    @Override
    public void analyzeClass(byte[] buffer, String location) throws IOException {
        try {
            this.analyzeClass(buffer);
        }
        catch (RuntimeException cause) {
            throw this.analyzerError(location, cause);
        }
    }

    public void analyzeClass(ClassReader reader) {
        Map<Integer, BranchExp> lineToBranchExp = this.mapProbes(reader);
        long classid = CRC64.classId(reader.b);
        ExecutionData classData = this.executionData.get(classid);
        if (classData == null) {
            return;
        }
        boolean[] probes = classData.getProbes();
        BranchCoverageDetail detail = new BranchCoverageDetail();
        for (Map.Entry<Integer, BranchExp> entry : lineToBranchExp.entrySet()) {
            int line = entry.getKey();
            BranchExp branchExp = entry.getValue();
            List<CovExp> branches = branchExp.getBranches();
            detail.setBranches(line, branches.size());
            for (int branchIdx = 0; branchIdx < branches.size(); ++branchIdx) {
                if (!branches.get(branchIdx).eval(probes)) continue;
                detail.setTakenBit(line, branchIdx);
            }
        }
        if (detail.linesWithBranches().size() > 0) {
            this.branchDetails.put(reader.getClassName(), detail);
        }
    }

    private void analyzeClass(byte[] source) {
        ClassReader reader = new ClassReader(source);
        this.analyzeClass(reader);
    }

    private IOException analyzerError(String location, Exception cause) {
        IOException ex = new IOException(String.format("Error while analyzing %s.", location));
        ex.initCause(cause);
        return ex;
    }

    private Map<Integer, BranchExp> mapProbes(ClassReader reader) {
        ClassProbesMapper mapper = new ClassProbesMapper(reader.getClassName());
        ClassProbesAdapter adapter = new ClassProbesAdapter(mapper, false);
        reader.accept(adapter, 0);
        return mapper.result();
    }

    public Map<String, BranchCoverageDetail> getBranchDetails() {
        return this.branchDetails;
    }
}

