/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import com.google.testing.coverage.BitField;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class BranchCoverageDetail {
    private final Map<Integer, BitField> branchTaken = new TreeMap<Integer, BitField>();
    private final Map<Integer, Integer> branches = new TreeMap<Integer, Integer>();

    private BitField getBranchForLine(int line) {
        BitField value = this.branchTaken.get(line);
        if (value != null) {
            return value;
        }
        value = new BitField();
        this.branchTaken.put(line, value);
        return value;
    }

    public boolean hasBranches(int line) {
        return this.branches.containsKey(line);
    }

    public void setBranches(int line, int n) {
        this.branches.put(line, n);
    }

    public int getBranches(int line) {
        Integer value = this.branches.get(line);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void setTakenBit(int line, int branchIdx) {
        this.getBranchForLine(line).setBit(branchIdx);
    }

    public boolean getTakenBit(int line, int branchIdx) {
        return this.getBranchForLine(line).isBitSet(branchIdx);
    }

    public boolean getExecutedBit(int line) {
        return this.getBranchForLine(line).any();
    }

    public Set<Integer> linesWithBranches() {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int i : this.branches.keySet()) {
            if (this.branches.get(i) <= 1) continue;
            result.add(i);
        }
        return result;
    }
}

