/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.coverage;

import java.util.Arrays;

public class BitField {
    private byte[] bytes;
    private static final int[] BIT_COUNT_LOOKUP = new int[256];

    public BitField() {
        this(new byte[0]);
    }

    public BitField(byte[] bytes) {
        this.bytes = (byte[])bytes.clone();
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public void setBit(int index) {
        this.setBit(index, true);
    }

    private void setBit(int index, boolean isSet) {
        int byteIndex = index / 8;
        int newByteSize = byteIndex + 1;
        if (this.bytes.length < newByteSize) {
            this.bytes = Arrays.copyOf(this.bytes, newByteSize);
        }
        int bitIndex = index % 8;
        int mask = 1 << bitIndex;
        this.bytes[byteIndex] = isSet ? (byte)(this.bytes[byteIndex] | mask) : (byte)(this.bytes[byteIndex] & ~mask);
    }

    public void clearBit(int index) {
        this.setBit(index, false);
    }

    public boolean isBitSet(int index) {
        int byteIndex = index / 8;
        if (byteIndex >= this.bytes.length) {
            return false;
        }
        int bitIndex = index % 8;
        int mask = 1 << bitIndex;
        return (this.bytes[byteIndex] & mask) != 0;
    }

    public BitField and(BitField other) {
        int size = Math.min(this.bytes.length, other.bytes.length);
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(this.bytes[i] & other.bytes[i]);
        }
        return new BitField(result);
    }

    public BitField or(BitField other) {
        byte[] smallerArray;
        byte[] largerArray;
        if (this.bytes.length < other.bytes.length) {
            largerArray = other.bytes;
            smallerArray = this.bytes;
        } else {
            largerArray = this.bytes;
            smallerArray = other.bytes;
        }
        byte[] result = Arrays.copyOf(largerArray, largerArray.length);
        for (int i = 0; i < smallerArray.length; ++i) {
            int n = i;
            result[n] = (byte)(result[n] | smallerArray[i]);
        }
        return new BitField(result);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BitField)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((BitField)obj).bytes);
    }

    public boolean equals(byte[] other) {
        return Arrays.equals(this.bytes, other);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public int countBitsSet() {
        int count = 0;
        for (byte b : this.bytes) {
            count += BIT_COUNT_LOOKUP[0xFF & b];
        }
        return count;
    }

    public BitField not() {
        byte[] invertedBytes = new byte[this.bytes.length];
        for (int i = 0; i < this.bytes.length; ++i) {
            invertedBytes[i] = Integer.valueOf(~this.bytes[i]).byteValue();
        }
        return new BitField(invertedBytes);
    }

    public int sizeInBits() {
        return this.bytes.length * 8;
    }

    public boolean any() {
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == 0) continue;
            return true;
        }
        return false;
    }

    static {
        BitField.BIT_COUNT_LOOKUP[0] = 0;
        BitField.BIT_COUNT_LOOKUP[1] = 1;
        for (int i = 2; i < 256; i += 2) {
            int count;
            BitField.BIT_COUNT_LOOKUP[i] = count = BIT_COUNT_LOOKUP[i / 2];
            BitField.BIT_COUNT_LOOKUP[i + 1] = count + 1;
        }
    }
}

