/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class RecordsFilter
implements IFilter {
    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (!"java/lang/Record".equals(context.getSuperClassName())) {
            return;
        }
        Matcher matcher = new Matcher();
        if (matcher.isEquals(methodNode) || matcher.isHashCode(methodNode) || matcher.isToString(methodNode) || matcher.isFieldAccessor(methodNode)) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        boolean isToString(MethodNode m4) {
            if (!"toString".equals(m4.name) || !"()Ljava/lang/String;".equals(m4.desc)) {
                return false;
            }
            this.firstIsALoad0(m4);
            this.nextIsInvokeDynamic("toString");
            this.nextIs(176);
            return this.cursor != null;
        }

        boolean isHashCode(MethodNode m4) {
            if (!"hashCode".equals(m4.name) || !"()I".equals(m4.desc)) {
                return false;
            }
            this.firstIsALoad0(m4);
            this.nextIsInvokeDynamic("hashCode");
            this.nextIs(172);
            return this.cursor != null;
        }

        boolean isFieldAccessor(MethodNode m4) {
            if (!m4.desc.startsWith("()")) {
                return false;
            }
            this.firstIsALoad0(m4);
            this.nextIs(180);
            if (!(this.cursor instanceof FieldInsnNode)) {
                return false;
            }
            if (!((FieldInsnNode)this.cursor).name.equals(m4.name)) {
                return false;
            }
            this.next();
            if (this.cursor == null) {
                return false;
            }
            switch (this.cursor.getOpcode()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    return true;
                }
            }
            return false;
        }

        boolean isEquals(MethodNode m4) {
            if (!"equals".equals(m4.name) || !"(Ljava/lang/Object;)Z".equals(m4.desc)) {
                return false;
            }
            this.firstIsALoad0(m4);
            this.nextIs(25);
            this.nextIsInvokeDynamic("equals");
            this.nextIs(172);
            return this.cursor != null;
        }

        private void nextIsInvokeDynamic(String name) {
            this.nextIs(186);
            if (this.cursor == null) {
                return;
            }
            InvokeDynamicInsnNode i = (InvokeDynamicInsnNode)this.cursor;
            Handle bsm = i.bsm;
            if (name.equals(i.name) && "java/lang/runtime/ObjectMethods".equals(bsm.getOwner()) && "bootstrap".equals(bsm.getName())) {
                return;
            }
            this.cursor = null;
        }
    }
}

