/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jacoco.core.analysis.CoverageNodeImpl;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.internal.analysis.PackageCoverageImpl;

public class BundleCoverageImpl
extends CoverageNodeImpl
implements IBundleCoverage {
    private final Collection<IPackageCoverage> packages;

    public BundleCoverageImpl(String name, Collection<IPackageCoverage> packages) {
        super(ICoverageNode.ElementType.BUNDLE, name);
        this.packages = packages;
        this.increment(packages);
    }

    public BundleCoverageImpl(String name, Collection<IClassCoverage> classes, Collection<ISourceFileCoverage> sourcefiles) {
        this(name, BundleCoverageImpl.groupByPackage(classes, sourcefiles));
    }

    private static Collection<IPackageCoverage> groupByPackage(Collection<IClassCoverage> classes, Collection<ISourceFileCoverage> sourcefiles) {
        HashMap classesByPackage = new HashMap();
        for (IClassCoverage iClassCoverage : classes) {
            BundleCoverageImpl.addByName(classesByPackage, iClassCoverage.getPackageName(), iClassCoverage);
        }
        HashMap sourceFilesByPackage = new HashMap();
        for (ISourceFileCoverage s2 : sourcefiles) {
            BundleCoverageImpl.addByName(sourceFilesByPackage, s2.getPackageName(), s2);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(classesByPackage.keySet());
        hashSet.addAll(sourceFilesByPackage.keySet());
        ArrayList<IPackageCoverage> result = new ArrayList<IPackageCoverage>();
        for (String name : hashSet) {
            List<ISourceFileCoverage> s3;
            List<IClassCoverage> c = (List<IClassCoverage>)classesByPackage.get(name);
            if (c == null) {
                c = Collections.emptyList();
            }
            if ((s3 = (List<ISourceFileCoverage>)sourceFilesByPackage.get(name)) == null) {
                s3 = Collections.emptyList();
            }
            result.add(new PackageCoverageImpl(name, c, s3));
        }
        return result;
    }

    private static <T> void addByName(Map<String, Collection<T>> map, String name, T value) {
        Collection<T> list = map.get(name);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(name, list);
        }
        list.add(value);
    }

    @Override
    public Collection<IPackageCoverage> getPackages() {
        return this.packages;
    }
}

