/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.errorprone.javacutil.BugInCF;

public class SwitchExpressionNode
extends Node {
    private final Tree switchExpressionTree;
    private final LocalVariableNode switchExpressionVar;

    public SwitchExpressionNode(TypeMirror type, Tree switchExpressionTree, LocalVariableNode switchExpressionVar) {
        super(type);
        if (!switchExpressionTree.getKind().name().equals("SWITCH_EXPRESSION")) {
            throw new BugInCF("switchExpressionTree is not a SwitchExpressionTree found tree with kind %s instead.", new Object[]{switchExpressionTree.getKind()});
        }
        this.switchExpressionTree = switchExpressionTree;
        this.switchExpressionVar = switchExpressionVar;
    }

    @Override
    public Tree getTree() {
        return this.switchExpressionTree;
    }

    public LocalVariableNode getSwitchExpressionVar() {
        return this.switchExpressionVar;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitSwitchExpressionNode(this, p);
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singleton(this.switchExpressionVar);
    }

    public String toString() {
        return "SwitchExpressionNode{switchExpressionTree=" + this.switchExpressionTree + ", switchExpressionVar=" + this.switchExpressionVar + '}';
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof SwitchExpressionNode)) {
            return false;
        }
        SwitchExpressionNode other = (SwitchExpressionNode)obj;
        return this.getTree().equals(other.getTree()) && this.getSwitchExpressionVar().equals(other.getSwitchExpressionVar());
    }

    public int hashCode() {
        return Objects.hash(this.getTree(), this.getSwitchExpressionVar());
    }
}

