/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.node;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.errorprone.javacutil.TreeUtils;

public class ClassNameNode
extends Node {
    protected final @Nullable Tree tree;
    protected final Element element;
    protected final @Nullable Node parent;

    public ClassNameNode(IdentifierTree tree) {
        super(TreeUtils.typeOf(tree));
        assert (tree.getKind() == Tree.Kind.IDENTIFIER);
        this.tree = tree;
        assert (TreeUtils.isUseOfElement(tree)) : "@AssumeAssertion(nullness): tree kind";
        Element element = TreeUtils.elementFromUse(tree);
        assert (element instanceof TypeElement || element instanceof TypeParameterElement) : "@AssumeAssertion(nullness)";
        this.element = element;
        this.parent = null;
    }

    public ClassNameNode(ClassTree tree) {
        super(TreeUtils.typeOf(tree));
        this.tree = tree;
        TypeElement element = TreeUtils.elementFromDeclaration(tree);
        assert (element instanceof TypeElement || element instanceof TypeParameterElement) : "@AssumeAssertion(nullness)";
        this.element = element;
        this.parent = null;
    }

    public ClassNameNode(MemberSelectTree tree, Node parent) {
        super(TreeUtils.typeOf(tree));
        this.tree = tree;
        assert (TreeUtils.isUseOfElement(tree)) : "@AssumeAssertion(nullness): tree kind";
        Element element = TreeUtils.elementFromUse(tree);
        assert (element instanceof TypeElement || element instanceof TypeParameterElement) : "@AssumeAssertion(nullness)";
        this.element = element;
        this.parent = parent;
    }

    public ClassNameNode(TypeMirror type, Element element) {
        super(type);
        this.tree = null;
        this.element = element;
        assert (element instanceof TypeElement || element instanceof TypeParameterElement);
        this.parent = null;
    }

    public Element getElement() {
        return this.element;
    }

    public @Nullable Node getParent() {
        return this.parent;
    }

    @Override
    public @Nullable Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitClassName(this, p);
    }

    public String toString() {
        return this.getElement().getSimpleName().toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ClassNameNode)) {
            return false;
        }
        ClassNameNode other = (ClassNameNode)obj;
        return Objects.equals(this.getParent(), other.getParent()) && this.getElement().equals(other.getElement());
    }

    public int hashCode() {
        return Objects.hash(this.getElement(), this.getParent());
    }

    @Override
    public Collection<Node> getOperands() {
        if (this.parent == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.parent);
    }
}

