/*
 * Decompiled with CFR 0.152.
 */
package com.ryanharter.auto.value.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface GenerateTypeAdapter {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){
        private final Class<?> typeArrayClass = Array.newInstance(Type.class, 0).getClass();
        private final Map<Class<?>, Constructor<? extends TypeAdapter>> adapters = Collections.synchronizedMap(new LinkedHashMap());

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class<T> rawType = type.getRawType();
            if (!rawType.isAnnotationPresent(GenerateTypeAdapter.class)) {
                return null;
            }
            Class<T> superClass = rawType.getSuperclass();
            if (superClass.isAnnotationPresent(GenerateTypeAdapter.class)) {
                return gson.getAdapter(superClass);
            }
            Constructor<? extends TypeAdapter> constructor = this.findConstructorForClass(rawType);
            if (constructor == null) {
                return null;
            }
            try {
                if (constructor.getParameterTypes().length == 1) {
                    return constructor.newInstance(gson);
                }
                return constructor.newInstance(gson, ((ParameterizedType)type.getType()).getActualTypeArguments());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to invoke " + constructor, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to invoke " + constructor, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException("Could not create generated TypeAdapter instance for type " + rawType, cause);
            }
        }

        private Constructor<? extends TypeAdapter> findConstructorForClass(Class<?> cls) {
            Constructor<TypeAdapter<Object>> adapterCtor = this.adapters.get(cls);
            if (adapterCtor != null) {
                return adapterCtor;
            }
            String clsName = cls.getName();
            if (clsName.startsWith("android.") || clsName.startsWith("java.") || clsName.startsWith("kotlin.")) {
                return null;
            }
            try {
                String nameAdjusted = cls.getName().replace("$", "_");
                Class<?> bindingClass = cls.getClassLoader().loadClass(nameAdjusted + "_GsonTypeAdapter");
                try {
                    adapterCtor = bindingClass.getDeclaredConstructor(Gson.class);
                    adapterCtor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    adapterCtor = bindingClass.getDeclaredConstructor(Gson.class, this.typeArrayClass);
                    adapterCtor.setAccessible(true);
                }
            }
            catch (ClassNotFoundException e) {
                Constructor<? extends TypeAdapter> superClassAdapter = this.findConstructorForClass(cls.getSuperclass());
                if (superClassAdapter != null) {
                    superClassAdapter.setAccessible(true);
                }
                adapterCtor = superClassAdapter;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Unable to find binding constructor for " + clsName, e);
            }
            this.adapters.put(cls, adapterCtor);
            return adapterCtor;
        }
    };
}

