/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import java.util.Map;

public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final CharEscaper JAVA_CHAR_ESCAPER = new JavaCharEscaper(ImmutableMap.of(Character.valueOf('\b'), "\\b", Character.valueOf('\f'), "\\f", Character.valueOf('\n'), "\\n", Character.valueOf('\r'), "\\r", Character.valueOf('\t'), "\\t", Character.valueOf('\"'), "\\\"", Character.valueOf('\\'), "\\\\", Character.valueOf('\''), "\\'"));

    private SourceCodeEscapers() {
    }

    public static CharEscaper javaCharEscaper() {
        return JAVA_CHAR_ESCAPER;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    private static class JavaCharEscaper
    extends ArrayBasedCharEscaper {
        JavaCharEscaper(Map<Character, String> replacements) {
            super(replacements, ' ', '~');
        }

        @Override
        protected char[] escapeUnsafe(char c) {
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }
    }
}

