/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class Signatures {
    private static final Type.Visitor<String, Void> PRETTY_TYPE_VISITOR = new Types.DefaultTypeVisitor<String, Void>(){

        @Override
        public String visitWildcardType(Type.WildcardType t2, Void unused) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)t2.kind);
            if (t2.kind != BoundKind.UNBOUND) {
                sb.append(t2.type.accept(this, null));
            }
            return sb.toString();
        }

        @Override
        public String visitClassType(Type.ClassType t2, Void s2) {
            StringBuilder sb = new StringBuilder();
            sb.append(t2.tsym.getSimpleName());
            if (((List)t2.getTypeArguments()).nonEmpty()) {
                sb.append('<');
                sb.append(t2.getTypeArguments().stream().map(a -> a.accept(this, null)).collect(Collectors.joining(", ")));
                sb.append(">");
            }
            return sb.toString();
        }

        @Override
        public String visitCapturedType(Type.CapturedType t2, Void s2) {
            return t2.wildcard.accept(this, null);
        }

        @Override
        public String visitArrayType(Type.ArrayType t2, Void unused) {
            return t2.elemtype.accept(this, null) + "[]";
        }

        @Override
        public String visitType(Type t2, Void s2) {
            return t2.toString();
        }
    };

    public static String classDescriptor(Type type, Types types) {
        SigGen sig = new SigGen(types);
        sig.assembleClassSig(types.erasure(type));
        return sig.toString();
    }

    public static String descriptor(Type type, Types types) {
        SigGen sig = new SigGen(types);
        sig.assembleSig(types.erasure(type));
        return sig.toString();
    }

    public static String prettyMethodSignature(Symbol.ClassSymbol origin, Symbol.MethodSymbol m4) {
        StringBuilder sb = new StringBuilder();
        if (m4.isConstructor()) {
            javax.lang.model.element.Name name = m4.owner.enclClass().getSimpleName();
            if (name.isEmpty()) {
                name = m4.owner.enclClass().getSuperclass().asElement().getSimpleName();
            }
            sb.append(name);
        } else {
            if (!m4.owner.equals(origin)) {
                sb.append(m4.owner.getSimpleName()).append('.');
            }
            sb.append(m4.getSimpleName());
        }
        sb.append(m4.getParameters().stream().map(v -> v.type.accept(PRETTY_TYPE_VISITOR, null)).collect(Collectors.joining(", ", "(", ")")));
        return sb.toString();
    }

    public static String prettyType(Type type) {
        return type.accept(PRETTY_TYPE_VISITOR, null);
    }

    private Signatures() {
    }

    private static class SigGen
    extends Types.SignatureGenerator {
        private final ByteBuffer buffer = new ByteBuffer();

        protected SigGen(Types types) {
            super(types);
        }

        @Override
        protected void append(char ch) {
            this.buffer.appendByte(ch);
        }

        @Override
        protected void append(byte[] ba) {
            this.buffer.appendBytes(ba);
        }

        @Override
        protected void append(Name name) {
            this.buffer.appendName(name);
        }

        public String toString() {
            return new String(Arrays.copyOf(this.buffer.elems, this.buffer.length), StandardCharsets.UTF_8);
        }
    }
}

