/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.InstanceReturningScannerSupplierImpl;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplierImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class ScannerSupplier
implements Supplier<Scanner> {
    @SafeVarargs
    public static ScannerSupplier fromBugCheckerClasses(Class<? extends BugChecker> ... checkerClasses) {
        return ScannerSupplier.fromBugCheckerClasses(Arrays.asList(checkerClasses));
    }

    private static ImmutableMap<String, BugPattern.SeverityLevel> defaultSeverities(Iterable<BugCheckerInfo> checkers) {
        ImmutableMap.Builder<String, BugPattern.SeverityLevel> severities = ImmutableMap.builder();
        for (BugCheckerInfo check : checkers) {
            severities.put(check.canonicalName(), check.defaultSeverity());
        }
        return severities.buildOrThrow();
    }

    public static ScannerSupplier fromBugCheckerClasses(Iterable<Class<? extends BugChecker>> checkers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<? extends BugChecker> checker : checkers) {
            builder.add(BugCheckerInfo.create(checker));
        }
        return ScannerSupplier.fromBugCheckerInfos(builder.build());
    }

    public static ScannerSupplier fromBugCheckerInfos(Iterable<BugCheckerInfo> checkers) {
        ImmutableBiMap<String, BugCheckerInfo> allChecks = Streams.stream(checkers).collect(ImmutableBiMap.toImmutableBiMap(BugCheckerInfo::canonicalName, checker -> checker));
        return new ScannerSupplierImpl(allChecks, ScannerSupplier.defaultSeverities(allChecks.values()), ImmutableSet.of(), ErrorProneFlags.empty());
    }

    public static ScannerSupplier fromScanner(Scanner scanner) {
        return new InstanceReturningScannerSupplierImpl(scanner);
    }

    public abstract ImmutableBiMap<String, BugCheckerInfo> getAllChecks();

    public abstract ImmutableSet<BugCheckerInfo> getEnabledChecks();

    public abstract ImmutableMap<String, BugPattern.SeverityLevel> severities();

    protected abstract ImmutableSet<String> disabled();

    protected Set<String> enabled() {
        return Sets.difference(this.getAllChecks().keySet(), this.disabled());
    }

    public abstract ErrorProneFlags getFlags();

    @CheckReturnValue
    public ScannerSupplier applyOverrides(ErrorProneOptions errorProneOptions) {
        ImmutableMap<String, ErrorProneOptions.Severity> severityOverrides = errorProneOptions.getSeverityMap();
        if (severityOverrides.isEmpty() && errorProneOptions.getFlags().isEmpty() && !errorProneOptions.isEnableAllChecksAsWarnings() && !errorProneOptions.isDropErrorsToWarnings() && !errorProneOptions.isDisableAllChecks() && !errorProneOptions.isDisableAllWarnings()) {
            return this;
        }
        ImmutableBiMap<String, BugCheckerInfo> checks = this.getAllChecks();
        LinkedHashMap<String, BugPattern.SeverityLevel> severities = new LinkedHashMap<String, BugPattern.SeverityLevel>(this.severities());
        HashSet<String> disabled = new HashSet<String>(this.disabled());
        HashMap<String, String> flagsMap = new HashMap<String, String>(this.getFlags().getFlagsMap());
        if (errorProneOptions.isEnableAllChecksAsWarnings()) {
            disabled.forEach(c -> severities.put((String)c, BugPattern.SeverityLevel.WARNING));
            disabled.clear();
        }
        if (errorProneOptions.isDropErrorsToWarnings()) {
            checks.values().stream().filter((? super T c) -> c.defaultSeverity() == BugPattern.SeverityLevel.ERROR && c.disableable()).forEach(c -> severities.put(c.canonicalName(), BugPattern.SeverityLevel.WARNING));
        }
        if (errorProneOptions.isDisableAllWarnings()) {
            checks.values().stream().filter((? super T c) -> c.defaultSeverity() == BugPattern.SeverityLevel.WARNING).forEach(c -> disabled.add(c.canonicalName()));
        }
        if (errorProneOptions.isDisableAllChecks()) {
            checks.values().stream().filter((? super T c) -> c.disableable()).forEach(c -> disabled.add(c.canonicalName()));
        }
        ImmutableMultimap checksByAltName = checks.values().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(x -> x, c -> c.allNames().stream())).inverse();
        severityOverrides.forEach((arg_0, arg_1) -> this.lambda$applyOverrides$10((ImmutableListMultimap)checksByAltName, errorProneOptions, severities, disabled, arg_0, arg_1));
        flagsMap.putAll(errorProneOptions.getFlags().getFlagsMap());
        return new ScannerSupplierImpl(checks, ImmutableMap.copyOf(severities), ImmutableSet.copyOf(disabled), ErrorProneFlags.fromMap(flagsMap));
    }

    @CheckReturnValue
    public ScannerSupplier plus(ScannerSupplier other) {
        HashBiMap<String, BugCheckerInfo> combinedAllChecks = HashBiMap.create(this.getAllChecks());
        other.getAllChecks().forEach((k, v) -> {
            BugCheckerInfo existing = combinedAllChecks.putIfAbsent((String)k, (BugCheckerInfo)v);
            if (existing != null && !existing.checkerClass().getName().contentEquals(v.checkerClass().getName())) {
                throw new IllegalArgumentException(String.format("Cannot combine scanner suppliers with different implementations of '%s': %s, %s", k, v.checkerClass().getName(), existing.checkerClass().getName()));
            }
        });
        LinkedHashMap<String, BugPattern.SeverityLevel> combinedSeverities = new LinkedHashMap<String, BugPattern.SeverityLevel>(this.severities());
        other.severities().forEach((k, v) -> {
            BugPattern.SeverityLevel existing = combinedSeverities.putIfAbsent((String)k, (BugPattern.SeverityLevel)((Object)v));
            if (existing != null && !existing.equals(v)) {
                throw new IllegalArgumentException(String.format("Cannot combine scanner suppliers with different severities for '%s': %s, %s", new Object[]{k, v, existing}));
            }
        });
        ImmutableSet<String> disabled = Sets.difference(combinedAllChecks.keySet(), Sets.union(this.enabled(), other.enabled())).immutableCopy();
        ErrorProneFlags combinedFlags = this.getFlags().plus(other.getFlags());
        return new ScannerSupplierImpl(ImmutableBiMap.copyOf(combinedAllChecks), ImmutableMap.copyOf(combinedSeverities), disabled, combinedFlags);
    }

    @CheckReturnValue
    public ScannerSupplier filter(Predicate<? super BugCheckerInfo> predicate) {
        ImmutableSet<String> disabled = this.getAllChecks().values().stream().filter(predicate.negate()).map(BugCheckerInfo::canonicalName).collect(ImmutableSet.toImmutableSet());
        return new ScannerSupplierImpl(this.getAllChecks(), this.severities(), disabled, this.getFlags());
    }

    private /* synthetic */ void lambda$applyOverrides$10(ImmutableListMultimap checksByAltName, ErrorProneOptions errorProneOptions, Map severities, Set disabled, String checkName, ErrorProneOptions.Severity newSeverity) {
        if (!checksByAltName.containsKey(checkName)) {
            if (errorProneOptions.ignoreUnknownChecks()) {
                return;
            }
            throw new InvalidCommandLineOptionException(checkName + " is not a valid checker name");
        }
        for (BugCheckerInfo check : checksByAltName.get(checkName)) {
            switch (newSeverity) {
                case OFF: {
                    if (!check.disableable()) {
                        throw new InvalidCommandLineOptionException(check.canonicalName() + " may not be disabled");
                    }
                    severities.remove(check.canonicalName());
                    disabled.add(check.canonicalName());
                    break;
                }
                case DEFAULT: {
                    severities.put(check.canonicalName(), check.defaultSeverity());
                    disabled.remove(check.canonicalName());
                    break;
                }
                case WARN: {
                    if (!this.disabled().contains(check.canonicalName()) && !check.disableable() && check.defaultSeverity() == BugPattern.SeverityLevel.ERROR) {
                        throw new InvalidCommandLineOptionException(check.canonicalName() + " is not disableable and may not be demoted to a warning");
                    }
                    severities.put(check.canonicalName(), BugPattern.SeverityLevel.WARNING);
                    disabled.remove(check.canonicalName());
                    break;
                }
                case ERROR: {
                    severities.put(check.canonicalName(), BugPattern.SeverityLevel.ERROR);
                    disabled.remove(check.canonicalName());
                }
            }
        }
    }
}

