/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_UIntersectionType;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;

@AutoValue
abstract class UIntersectionType
extends UExpression
implements IntersectionTypeTree {
    UIntersectionType() {
    }

    @VisibleForTesting
    static UIntersectionType create(UExpression ... bounds) {
        return UIntersectionType.create(ImmutableList.copyOf(bounds));
    }

    static UIntersectionType create(Iterable<? extends UExpression> bounds) {
        return new AutoValue_UIntersectionType(ImmutableList.copyOf(bounds));
    }

    public abstract ImmutableList<UExpression> getBounds();

    @Override
    public JCTree.JCTypeIntersection inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().TypeIntersection(inliner.inlineList(this.getBounds()));
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.INTERSECTION_TYPE;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitIntersectionType(this, data);
    }

    @Override
    public Choice<Unifier> visitIntersectionType(IntersectionTypeTree node, Unifier unifier) {
        return Unifier.unifyList(unifier, this.getBounds(), node.getBounds());
    }
}

