/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.AutoValue_UIf;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.ControlFlowVisitor;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UBlock;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import javax.annotation.Nullable;

@AutoValue
abstract class UIf
implements UStatement,
IfTree {
    UIf() {
    }

    public static UIf create(UExpression condition, UStatement thenStatement, UStatement elseStatement) {
        return new AutoValue_UIf(condition, thenStatement, elseStatement);
    }

    @Override
    public abstract UExpression getCondition();

    @Override
    public abstract UStatement getThenStatement();

    @Override
    @Nullable
    public abstract UStatement getElseStatement();

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitIf(this, data);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IF;
    }

    private static Function<Unifier, Choice<Unifier>> unifyUStatementWithSingleStatement(@Nullable UStatement toUnify, @Nullable StatementTree target) {
        return unifier -> {
            if (toUnify == null) {
                return target == null ? Choice.of(unifier) : Choice.none();
            }
            List<Object> list = target == null ? List.nil() : List.of(target);
            return ((Choice)toUnify.apply(UStatement.UnifierWithUnconsumedStatements.create(unifier, list))).condition(s2 -> s2.unconsumedStatements().isEmpty()).transform(UStatement.UnifierWithUnconsumedStatements::unifier);
        };
    }

    @Override
    @Nullable
    public Choice<UStatement.UnifierWithUnconsumedStatements> apply(UStatement.UnifierWithUnconsumedStatements state) {
        ImmutableList<? extends StatementTree> unconsumedStatements = state.unconsumedStatements();
        if (unconsumedStatements.isEmpty()) {
            return Choice.none();
        }
        java.util.List unconsumedStatementsTail = unconsumedStatements.subList(1, unconsumedStatements.size());
        StatementTree firstStatement = (StatementTree)unconsumedStatements.get(0);
        if (firstStatement.getKind() != Tree.Kind.IF) {
            return Choice.none();
        }
        IfTree ifTree = (IfTree)firstStatement;
        Unifier unifier = state.unifier();
        Choice forwardMatch = this.getCondition().unify(ifTree.getCondition(), unifier.fork()).thenChoose(UIf.unifyUStatementWithSingleStatement(this.getThenStatement(), ifTree.getThenStatement())).thenChoose(arg_0 -> this.lambda$apply$3(ifTree, (ImmutableList)unconsumedStatementsTail, arg_0));
        Choice backwardMatch = this.getCondition().negate().unify(ifTree.getCondition(), unifier.fork()).thenChoose(unifierAfterCond -> {
            if (this.getElseStatement() == null) {
                return Choice.none();
            }
            return ((Choice)this.getElseStatement().apply(UStatement.UnifierWithUnconsumedStatements.create(unifierAfterCond, List.of(ifTree.getThenStatement())))).thenOption(stateAfterThen -> stateAfterThen.unconsumedStatements().isEmpty() ? Optional.of(stateAfterThen.unifier()) : Optional.absent());
        }).thenChoose(arg_0 -> this.lambda$apply$7(ifTree, (ImmutableList)unconsumedStatementsTail, arg_0));
        return forwardMatch.or(backwardMatch);
    }

    @Override
    public List<JCTree.JCStatement> inlineStatements(Inliner inliner) throws CouldNotResolveImportException {
        return List.of(inliner.maker().If((JCTree.JCExpression)this.getCondition().inline(inliner), Iterables.getOnlyElement(this.getThenStatement().inlineStatements(inliner)), this.getElseStatement() == null ? null : Iterables.getOnlyElement(this.getElseStatement().inlineStatements(inliner))));
    }

    private /* synthetic */ Choice lambda$apply$7(IfTree ifTree, ImmutableList unconsumedStatementsTail, Unifier unifierAfterThen) {
        if (ifTree.getElseStatement() == null && ControlFlowVisitor.INSTANCE.visitStatement(ifTree.getThenStatement()) == ControlFlowVisitor.Result.ALWAYS_RETURNS) {
            Choice<UStatement.UnifierWithUnconsumedStatements> result = (Choice<UStatement.UnifierWithUnconsumedStatements>)this.getThenStatement().apply(UStatement.UnifierWithUnconsumedStatements.create(unifierAfterThen.fork(), unconsumedStatementsTail));
            if (this.getThenStatement() instanceof UBlock) {
                Choice<UStatement.UnifierWithUnconsumedStatements> alternative = Choice.of(UStatement.UnifierWithUnconsumedStatements.create(unifierAfterThen.fork(), unconsumedStatementsTail));
                for (UStatement stmt : ((UBlock)this.getThenStatement()).getStatements()) {
                    alternative = alternative.thenChoose(stmt);
                }
                result = result.or(alternative);
            }
            return result;
        }
        return UIf.unifyUStatementWithSingleStatement(this.getThenStatement(), ifTree.getElseStatement()).apply(unifierAfterThen).transform(unifierAfterElse -> UStatement.UnifierWithUnconsumedStatements.create(unifierAfterElse, unconsumedStatementsTail));
    }

    private /* synthetic */ Choice lambda$apply$3(IfTree ifTree, ImmutableList unconsumedStatementsTail, Unifier unifierAfterThen) {
        if (this.getElseStatement() != null && ifTree.getElseStatement() == null && ControlFlowVisitor.INSTANCE.visitStatement(ifTree.getThenStatement()) == ControlFlowVisitor.Result.ALWAYS_RETURNS) {
            Choice<UStatement.UnifierWithUnconsumedStatements> result = (Choice<UStatement.UnifierWithUnconsumedStatements>)this.getElseStatement().apply(UStatement.UnifierWithUnconsumedStatements.create(unifierAfterThen.fork(), unconsumedStatementsTail));
            if (this.getElseStatement() instanceof UBlock) {
                Choice<UStatement.UnifierWithUnconsumedStatements> alternative = Choice.of(UStatement.UnifierWithUnconsumedStatements.create(unifierAfterThen.fork(), unconsumedStatementsTail));
                for (UStatement stmt : ((UBlock)this.getElseStatement()).getStatements()) {
                    alternative = alternative.thenChoose(stmt);
                }
                result = result.or(alternative);
            }
            return result;
        }
        return UIf.unifyUStatementWithSingleStatement(this.getElseStatement(), ifTree.getElseStatement()).apply(unifierAfterThen).transform(unifierAfterElse -> UStatement.UnifierWithUnconsumedStatements.create(unifierAfterElse, unconsumedStatementsTail));
    }
}

