/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.VerifyException;
import com.google.errorprone.refaster.AutoValue_UEnhancedForLoop;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.USimpleStatement;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.RuntimeVersion;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import java.util.Arrays;

@AutoValue
abstract class UEnhancedForLoop
extends USimpleStatement
implements EnhancedForLoopTree {
    UEnhancedForLoop() {
    }

    public static UEnhancedForLoop create(UVariableDecl variable, UExpression elements, UStatement statement) {
        return UEnhancedForLoop.isCompiledWithJdk20Plus() ? UEnhancedForLoop.createJdk20PlusEnhancedForLoop(variable, elements, statement) : UEnhancedForLoop.createPreJdk20EnhancedForLoop(variable, elements, statement);
    }

    private static boolean isCompiledWithJdk20Plus() {
        return Arrays.stream(AutoValue_UEnhancedForLoop.class.getDeclaredMethods()).anyMatch(m4 -> "getDeclarationKind".equals(m4.getName()));
    }

    private static UEnhancedForLoop createPreJdk20EnhancedForLoop(UVariableDecl variable, UExpression elements, UStatement statement) {
        try {
            return (UEnhancedForLoop)AutoValue_UEnhancedForLoop.class.getDeclaredConstructor(UVariableDecl.class, UExpression.class, USimpleStatement.class).newInstance(variable, elements, statement);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static UEnhancedForLoop createJdk20PlusEnhancedForLoop(UVariableDecl variable, UExpression elements, UStatement statement) {
        Object declarationKind = UEnhancedForLoop.getVariableDeclarationKind();
        try {
            return (UEnhancedForLoop)AutoValue_UEnhancedForLoop.class.getDeclaredConstructor(declarationKind.getClass(), UVariableDecl.class, UExpression.class, USimpleStatement.class).newInstance(declarationKind, variable, elements, statement);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Object getVariableDeclarationKind() {
        Class<?> declarationKind;
        try {
            declarationKind = Class.forName("com.sun.source.tree.EnhancedForLoopTree$DeclarationKind");
        }
        catch (ClassNotFoundException e) {
            throw new VerifyException("Cannot load `EnhancedForLoopTree.DeclarationKind` enum", e);
        }
        return Arrays.stream(declarationKind.getEnumConstants()).filter(v -> "VARIABLE".equals(v.toString())).findFirst().orElseThrow(() -> new VerifyException("Enum value `EnhancedForLoopTree.DeclarationKind.VARIABLE` not found"));
    }

    @Override
    public abstract UVariableDecl getVariable();

    @Override
    public abstract UExpression getExpression();

    @Override
    public abstract USimpleStatement getStatement();

    public Tree getVariableOrRecordPattern() {
        return this.getVariable();
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitEnhancedForLoop(this, data);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ENHANCED_FOR_LOOP;
    }

    @Override
    public JCTree.JCEnhancedForLoop inline(Inliner inliner) throws CouldNotResolveImportException {
        return UEnhancedForLoop.makeForeachLoop(inliner.maker(), this.getVariable().inline(inliner), (JCTree.JCExpression)this.getExpression().inline(inliner), (JCTree.JCStatement)this.getStatement().inline(inliner));
    }

    private static JCTree.JCEnhancedForLoop makeForeachLoop(TreeMaker maker, JCTree.JCVariableDecl variable, JCTree.JCExpression expression, JCTree.JCStatement statement) {
        try {
            if (RuntimeVersion.isAtLeast20()) {
                return (JCTree.JCEnhancedForLoop)TreeMaker.class.getMethod("ForeachLoop", JCTree.class, JCTree.JCExpression.class, JCTree.JCStatement.class).invoke((Object)maker, variable, expression, statement);
            }
            return (JCTree.JCEnhancedForLoop)TreeMaker.class.getMethod("ForeachLoop", JCTree.JCVariableDecl.class, JCTree.JCExpression.class, JCTree.JCStatement.class).invoke((Object)maker, variable, expression, statement);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    @Override
    public Choice<Unifier> visitEnhancedForLoop(EnhancedForLoopTree loop, Unifier unifier) {
        return this.getVariable().unify(loop.getVariable(), unifier).thenChoose(Unifier.unifications(this.getExpression(), loop.getExpression())).thenChoose(Unifier.unifications(this.getStatement(), loop.getStatement()));
    }
}

