/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_UAnyOf;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;

@AutoValue
public abstract class UAnyOf
extends UExpression {
    public static UAnyOf create(UExpression ... expressions) {
        return UAnyOf.create(ImmutableList.copyOf(expressions));
    }

    public static UAnyOf create(Iterable<? extends UExpression> expressions) {
        return new AutoValue_UAnyOf(ImmutableList.copyOf(expressions));
    }

    abstract ImmutableList<UExpression> expressions();

    @Override
    public UExpression negate() {
        ImmutableList.Builder negations = ImmutableList.builder();
        for (UExpression expression : this.expressions()) {
            negations.add(expression.negate());
        }
        return UAnyOf.create(negations.build());
    }

    @Override
    protected Choice<Unifier> defaultAction(Tree tree, Unifier unifier) {
        return Choice.from(this.expressions()).thenChoose(expression -> expression.unify(ASTHelpers.stripParentheses(tree), unifier.fork()));
    }

    @Override
    public JCTree.JCExpression inline(Inliner inliner) throws CouldNotResolveImportException {
        throw new UnsupportedOperationException("anyOf should not appear in an @AfterTemplate");
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return ((UExpression)this.expressions().get(0)).accept(visitor, data);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OTHER;
    }
}

