/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.LocalVarBinding;
import com.google.errorprone.refaster.PlaceholderUnificationVisitor;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UFreeIdent;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class PlaceholderVerificationVisitor
extends TreeScanner<Boolean, Unifier> {
    private final List<UExpression> unmatched;
    private final ImmutableList<UExpression> allowed;

    PlaceholderVerificationVisitor(Collection<? extends UExpression> required, Collection<? extends UExpression> allowed) {
        this.unmatched = new LinkedList<UExpression>(required);
        this.allowed = ImmutableList.copyOf(allowed);
        Preconditions.checkArgument(this.allowed.containsAll(this.unmatched), "allowed");
    }

    public boolean allRequiredMatched() {
        return this.unmatched.isEmpty();
    }

    private boolean couldUnify(UExpression expr, Tree tree, Unifier unifier) {
        return expr.unify(tree, unifier.fork()).first().isPresent();
    }

    @Override
    public Boolean scan(Tree node, Unifier unifier) {
        Iterator<UExpression> iterator = this.unmatched.iterator();
        while (iterator.hasNext()) {
            if (!this.couldUnify(iterator.next(), node, unifier)) continue;
            iterator.remove();
            return true;
        }
        for (UExpression expr : this.allowed) {
            if (!this.couldUnify(expr, node, unifier)) continue;
            return true;
        }
        if (node instanceof JCTree.JCExpression) {
            JCTree.JCExpression expr = (JCTree.JCExpression)node;
            for (UFreeIdent.Key key : Iterables.filter(unifier.getBindings().keySet(), UFreeIdent.Key.class)) {
                JCTree.JCExpression keyBinding = unifier.getBinding(key);
                if (!PlaceholderUnificationVisitor.equivalentExprs(unifier, expr, keyBinding)) continue;
                return false;
            }
        }
        return MoreObjects.firstNonNull((Boolean)super.scan(node, unifier), true);
    }

    @Override
    public Boolean visitIdentifier(IdentifierTree node, Unifier unifier) {
        for (LocalVarBinding localBinding : Iterables.filter(unifier.getBindings().values(), LocalVarBinding.class)) {
            if (!localBinding.getSymbol().equals(ASTHelpers.getSymbol(node))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean reduce(Boolean r1, Boolean r2) {
        return MoreObjects.firstNonNull(r1, true) != false && MoreObjects.firstNonNull(r2, true) != false;
    }
}

