/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.refaster.AutoValue_PlaceholderMethod;
import com.google.errorprone.refaster.Bindings;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UTemplater;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.annotation.Matches;
import com.google.errorprone.refaster.annotation.MayOptionallyUse;
import com.google.errorprone.refaster.annotation.NotMatches;
import com.google.errorprone.refaster.annotation.OfKind;
import com.google.errorprone.refaster.annotation.Placeholder;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;

@AutoValue
abstract class PlaceholderMethod
implements Serializable {
    PlaceholderMethod() {
    }

    static PlaceholderMethod create(CharSequence name, UType returnType, ImmutableMap<UVariableDecl, ImmutableClassToInstanceMap<Annotation>> parameters, ClassToInstanceMap<Annotation> annotations) {
        final boolean allowsIdentity = annotations.getInstance(Placeholder.class).allowsIdentity();
        final Class<? extends Matcher<? super ExpressionTree>> matchesClass = annotations.containsKey(Matches.class) ? UTemplater.getValue(annotations.getInstance(Matches.class)) : null;
        final Class<? extends Matcher<? super ExpressionTree>> notMatchesClass = annotations.containsKey(NotMatches.class) ? UTemplater.getValue(annotations.getInstance(NotMatches.class)) : null;
        final Predicate allowedKinds = annotations.containsKey(OfKind.class) ? Predicates.in(Arrays.asList(annotations.getInstance(OfKind.class).value())) : Predicates.alwaysTrue();
        class PlaceholderMatcher
        implements Matcher<ExpressionTree> {
            PlaceholderMatcher() {
            }

            @Override
            public boolean matches(ExpressionTree t2, VisitorState state) {
                try {
                    return !(!allowsIdentity && t2 instanceof UPlaceholderExpression.PlaceholderParamIdent || matchesClass != null && !((Matcher)matchesClass.newInstance()).matches(t2, state) || notMatchesClass != null && ((Matcher)notMatchesClass.newInstance()).matches(t2, state) || !allowedKinds.apply(t2.getKind()));
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new AutoValue_PlaceholderMethod(StringName.of(name), returnType, parameters, new PlaceholderMatcher(), ImmutableClassToInstanceMap.copyOf(annotations));
    }

    abstract StringName name();

    abstract UType returnType();

    abstract ImmutableMap<UVariableDecl, ImmutableClassToInstanceMap<Annotation>> annotatedParameters();

    abstract Matcher<ExpressionTree> matcher();

    abstract ImmutableClassToInstanceMap<Annotation> annotations();

    ImmutableSet<UVariableDecl> parameters() {
        return this.annotatedParameters().keySet();
    }

    Set<UVariableDecl> requiredParameters() {
        return Maps.filterValues(this.annotatedParameters(), annotations -> !annotations.containsKey(MayOptionallyUse.class)).keySet();
    }

    PlaceholderExpressionKey exprKey() {
        return new PlaceholderExpressionKey(this.name().contents(), this);
    }

    PlaceholderBlockKey blockKey() {
        return new PlaceholderBlockKey(this.name().contents(), this);
    }

    static final class PlaceholderBlockKey
    extends Bindings.Key<List<JCTree.JCStatement>> {
        final PlaceholderMethod method;

        private PlaceholderBlockKey(String str, PlaceholderMethod method) {
            super(str);
            this.method = method;
        }
    }

    static final class PlaceholderExpressionKey
    extends Bindings.Key<JCTree.JCExpression>
    implements Comparable<PlaceholderExpressionKey> {
        final PlaceholderMethod method;

        private PlaceholderExpressionKey(String str, PlaceholderMethod method) {
            super(str);
            this.method = method;
        }

        @Override
        public int compareTo(PlaceholderExpressionKey o) {
            return this.getIdentifier().compareTo(o.getIdentifier());
        }
    }
}

