/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.predicates;

import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.type.Array;
import com.google.errorprone.predicates.type.DescendantOf;
import com.google.errorprone.predicates.type.DescendantOfAny;
import com.google.errorprone.predicates.type.Exact;
import com.google.errorprone.predicates.type.ExactAny;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.tools.javac.code.Type;

public final class TypePredicates {
    public static TypePredicate isArray() {
        return Array.INSTANCE;
    }

    public static TypePredicate isExactType(String type) {
        return TypePredicates.isExactType(Suppliers.typeFromString(type));
    }

    public static TypePredicate isExactType(Supplier<Type> type) {
        return new Exact(type);
    }

    public static TypePredicate isExactTypeAny(Iterable<String> types) {
        return new ExactAny(Suppliers.fromStrings(types));
    }

    public static TypePredicate isDescendantOf(Supplier<Type> type) {
        return new DescendantOf(type);
    }

    public static TypePredicate isDescendantOfAny(Iterable<String> types) {
        return new DescendantOfAny(Suppliers.fromStrings(types));
    }

    public static TypePredicate isDescendantOf(String type) {
        return TypePredicates.isDescendantOf(Suppliers.typeFromString(type));
    }

    public static TypePredicate allOf(TypePredicate ... predicates) {
        return (type, state) -> {
            for (TypePredicate predicate : predicates) {
                if (predicate.apply(type, state)) continue;
                return false;
            }
            return true;
        };
    }

    public static TypePredicate anyOf(TypePredicate ... predicates) {
        return (type, state) -> {
            for (TypePredicate predicate : predicates) {
                if (!predicate.apply(type, state)) continue;
                return true;
            }
            return false;
        };
    }

    public static TypePredicate not(TypePredicate predicate) {
        return (type, state) -> !predicate.apply(type, state);
    }

    private TypePredicates() {
    }
}

