/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.names;

import blogspot.software_and_algorithms.stern_library.optimization.HungarianAlgorithm;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.names.LevenshteinEditDistance;
import com.google.errorprone.names.NamingConventions;
import java.util.function.BiFunction;
import java.util.stream.DoubleStream;

public class TermEditDistance {
    private final BiFunction<String, String, Double> editDistanceFn;
    private final BiFunction<Integer, Integer, Double> maxDistanceFn;

    public TermEditDistance(BiFunction<String, String, Double> editDistanceFn, BiFunction<Integer, Integer, Double> maxDistanceFn) {
        this.editDistanceFn = editDistanceFn;
        this.maxDistanceFn = maxDistanceFn;
    }

    public TermEditDistance() {
        this((s2, t2) -> LevenshteinEditDistance.getEditDistance(s2, t2, false), (s2, t2) -> LevenshteinEditDistance.getWorstCaseEditDistance(s2, t2));
    }

    public double getNormalizedEditDistance(String source, String target) {
        ImmutableList<String> sourceTerms = NamingConventions.splitToLowercaseTerms(source);
        ImmutableList<String> targetTerms = NamingConventions.splitToLowercaseTerms(target);
        double[][] costMatrix = (double[][])sourceTerms.stream().map(s2 -> targetTerms.stream().mapToDouble(t2 -> this.editDistanceFn.apply((String)s2, (String)t2)).toArray()).toArray(x$0 -> new double[x$0][]);
        double[][] worstCaseMatrix = (double[][])sourceTerms.stream().map(s2 -> s2.length()).map(s2 -> targetTerms.stream().map(t2 -> t2.length()).mapToDouble(t2 -> this.maxDistanceFn.apply((Integer)s2, (Integer)t2)).toArray()).toArray(x$0 -> new double[x$0][]);
        double[] sourceTermDeletionCosts = sourceTerms.stream().mapToDouble(s2 -> this.maxDistanceFn.apply(s2.length(), 0)).toArray();
        double[] targetTermAdditionCosts = targetTerms.stream().mapToDouble(s2 -> this.maxDistanceFn.apply(0, s2.length())).toArray();
        int[] assignments = new HungarianAlgorithm(costMatrix).execute();
        double assignmentCost = TermEditDistance.computeCost(assignments, costMatrix, sourceTermDeletionCosts, targetTermAdditionCosts);
        double maxCost = TermEditDistance.computeCost(assignments, worstCaseMatrix, sourceTermDeletionCosts, targetTermAdditionCosts);
        return assignmentCost / maxCost;
    }

    private static double computeCost(int[] assignments, double[][] costMatrix, double[] sourceTermDeletionCosts, double[] targetTermDeletionCosts) {
        double totalCost = DoubleStream.of(targetTermDeletionCosts).sum();
        for (int sourceTermIndex = 0; sourceTermIndex < assignments.length; ++sourceTermIndex) {
            int targetTermIndex = assignments[sourceTermIndex];
            if (targetTermIndex == -1) {
                totalCost += sourceTermDeletionCosts[sourceTermIndex];
                continue;
            }
            totalCost += costMatrix[sourceTermIndex][targetTermIndex];
            totalCost -= targetTermDeletionCosts[targetTermIndex];
        }
        return totalCost;
    }
}

