/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.AutoValue_MethodInvocationMatcher_Rule;
import com.google.errorprone.matchers.method.AutoValue_MethodInvocationMatcher_Token_DefinedIn;
import com.google.errorprone.matchers.method.AutoValue_MethodInvocationMatcher_Token_Kind;
import com.google.errorprone.matchers.method.AutoValue_MethodInvocationMatcher_Token_MethodName;
import com.google.errorprone.matchers.method.AutoValue_MethodInvocationMatcher_Token_ParameterTypes;
import com.google.errorprone.matchers.method.AutoValue_MethodInvocationMatcher_Token_ReceiverSupertype;
import com.google.errorprone.matchers.method.AutoValue_MethodInvocationMatcher_Token_ReceiverType;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

public class MethodInvocationMatcher {
    private static final Node ACCEPT = new Node();

    public static Matcher<ExpressionTree> compile(Iterable<Rule> rules) {
        HashBasedTable nfa = HashBasedTable.create();
        ImmutableSet.Builder rootsBuilder = ImmutableSet.builder();
        block0: for (Rule rule : rules) {
            ImmutableMap<TokenType, ? extends Set<Token>> required = rule.required();
            int numTokens = required.size();
            if (numTokens == 0) {
                return (tree, state) -> true;
            }
            Node root = new Node();
            rootsBuilder.add(root);
            Node src = root;
            int tokensHandled = 0;
            for (TokenType type : TokenType.values()) {
                Node dst;
                Optional<Set<Token>> labels = Optional.ofNullable(required.get((Object)type));
                if (labels.isPresent()) {
                    ++tokensHandled;
                }
                boolean lastToken = tokensHandled == numTokens;
                Node node = dst = lastToken ? ACCEPT : new Node();
                if (labels.isPresent()) {
                    for (Token label2 : labels.get()) {
                        nfa.put(src, Optional.of(label2), dst);
                    }
                } else {
                    nfa.put(src, Optional.empty(), dst);
                }
                if (lastToken) continue block0;
                src = dst;
            }
        }
        ImmutableCollection roots = rootsBuilder.build();
        HashMap<Set<Node>, NodeWithDefault> mappings = new HashMap<Set<Node>, NodeWithDefault>();
        ArrayDeque<Collection<Object>> open = new ArrayDeque<Collection<Object>>();
        open.add(roots);
        while (!open.isEmpty()) {
            Set curr = (Set)open.removeFirst();
            HashSet<Node> acceptsAny = new HashSet<Node>();
            HashMultimap<Token, Node> destinations = HashMultimap.create();
            for (Node node : curr) {
                for (Map.Entry entry : nfa.row(node).entrySet()) {
                    if (((Optional)entry.getKey()).isPresent()) continue;
                    acceptsAny.add((Node)entry.getValue());
                }
            }
            for (Node node : curr) {
                for (Map.Entry entry : nfa.row(node).entrySet()) {
                    ((Optional)entry.getKey()).ifPresent(label -> {
                        destinations.put((Token)label, (Node)entry.getValue());
                        destinations.putAll((Token)label, (Iterable<Node>)acceptsAny);
                    });
                }
            }
            mappings.put(curr, new NodeWithDefault(curr, acceptsAny.isEmpty() ? null : acceptsAny, destinations));
            if (!acceptsAny.isEmpty()) {
                open.addLast(acceptsAny);
            }
            Collection<Set<Node>> values = Multimaps.asMap(destinations).values();
            open.addAll(values);
        }
        return GraphMatcher.from(mappings, (NodeWithDefault)mappings.get(roots));
    }

    private MethodInvocationMatcher() {
    }

    private static final class GraphMatcher {
        private GraphMatcher() {
        }

        static Matcher<ExpressionTree> from(Map<Set<Node>, NodeWithDefault> mappings, NodeWithDefault root) {
            BiPredicate<Context, VisitorState> pred = GraphMatcher.traverse(mappings, root);
            return (tree, state) -> {
                Optional<Context> ctx = Context.create(tree);
                return ctx.isPresent() && pred.test(ctx.get(), state);
            };
        }

        private static BiPredicate<Context, VisitorState> traverse(Map<Set<Node>, NodeWithDefault> mappings, NodeWithDefault root) {
            if (root.states.contains(ACCEPT)) {
                return (ctx, state) -> true;
            }
            SetMultimap<Token, Node> children = root.mapping;
            if (children.isEmpty()) {
                Preconditions.checkArgument(root.def != null, "Found node with no mappings and no default");
                return GraphMatcher.traverse(mappings, mappings.get(root.def));
            }
            ImmutableSet tokenTypes = children.keySet().stream().map(Token::type).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument(tokenTypes.size() == 1, "Found mismatched token types in node with mappings %s", children);
            TokenType type = (TokenType)((Object)tokenTypes.iterator().next());
            BiPredicate<Context, VisitorState> defaultBehavior = root.def == null ? (ctx, state) -> false : GraphMatcher.traverse(mappings, mappings.get(root.def));
            HashMap<Object, BiPredicate<Context, VisitorState>> lookup = new HashMap<Object, BiPredicate<Context, VisitorState>>();
            Set<Map.Entry<Token, Set<Node>>> entries = Multimaps.asMap(children).entrySet();
            for (Map.Entry<Token, Set<Node>> entry : entries) {
                lookup.put(entry.getKey().comparisonKey(), GraphMatcher.traverse(mappings, mappings.get(entry.getValue())));
            }
            switch (type) {
                case RECEIVER_SUPERTYPE: {
                    return (ctx, state) -> {
                        Type receiverType = (Type)TokenType.RECEIVER_SUPERTYPE.extract((Context)ctx, (VisitorState)state);
                        for (Map.Entry child : lookup.entrySet()) {
                            if (!ASTHelpers.isSubtype(receiverType, state.getTypeFromString((String)child.getKey()), state)) continue;
                            return ((BiPredicate)child.getValue()).test(ctx, state);
                        }
                        return defaultBehavior.test((Context)ctx, (VisitorState)state);
                    };
                }
            }
            return (ctx, state) -> {
                Object lookupKey = type.extract((Context)ctx, (VisitorState)state);
                BiPredicate child = (BiPredicate)lookup.get(lookupKey);
                if (child != null) {
                    return child.test(ctx, state);
                }
                return defaultBehavior.test((Context)ctx, (VisitorState)state);
            };
        }
    }

    private static class NodeWithDefault {
        private final Set<Node> states;
        @Nullable
        final Set<Node> def;
        final SetMultimap<Token, Node> mapping;

        NodeWithDefault(Set<Node> states, Set<Node> def, SetMultimap<Token, Node> mapping) {
            this.states = states;
            this.def = def;
            this.mapping = mapping;
        }
    }

    private static class Node {
        private Node() {
        }
    }

    @AutoValue
    public static abstract class Rule {
        public static Rule create(ImmutableMap<TokenType, ? extends Set<Token>> required) {
            return new AutoValue_MethodInvocationMatcher_Rule(required);
        }

        public abstract ImmutableMap<TokenType, ? extends Set<Token>> required();
    }

    public static interface Token {
        public TokenType type();

        public Object comparisonKey();

        @AutoValue
        public static abstract class ReceiverSupertype
        implements Token {
            public abstract String receiverSupertype();

            @Override
            public TokenType type() {
                return TokenType.RECEIVER_SUPERTYPE;
            }

            public static ReceiverSupertype create(String receiverSupertype) {
                return new AutoValue_MethodInvocationMatcher_Token_ReceiverSupertype(receiverSupertype);
            }

            @Override
            public Object comparisonKey() {
                return this.receiverSupertype();
            }
        }

        @AutoValue
        public static abstract class ReceiverType
        implements Token {
            public abstract String receiverType();

            public static ReceiverType create(String receiverType) {
                return new AutoValue_MethodInvocationMatcher_Token_ReceiverType(receiverType);
            }

            @Override
            public Object comparisonKey() {
                return this.receiverType();
            }

            @Override
            public TokenType type() {
                return TokenType.RECEIVER_TYPE;
            }
        }

        @AutoValue
        public static abstract class DefinedIn
        implements Token {
            public abstract String owner();

            public static DefinedIn create(String owner) {
                return new AutoValue_MethodInvocationMatcher_Token_DefinedIn(owner);
            }

            @Override
            public TokenType type() {
                return TokenType.DEFINED_IN;
            }

            @Override
            public Object comparisonKey() {
                return this.owner();
            }
        }

        @AutoValue
        public static abstract class ParameterTypes
        implements Token {
            public abstract ImmutableList<String> parameterTypes();

            @Override
            public TokenType type() {
                return TokenType.PARAMETER_TYPES;
            }

            @Override
            public Object comparisonKey() {
                return this.parameterTypes();
            }

            public static ParameterTypes create(ImmutableList<String> types) {
                return new AutoValue_MethodInvocationMatcher_Token_ParameterTypes(types);
            }
        }

        @AutoValue
        public static abstract class MethodName
        implements Token {
            public abstract String methodName();

            @Override
            public Object comparisonKey() {
                return this.methodName();
            }

            @Override
            public TokenType type() {
                return TokenType.METHOD_NAME;
            }

            public static MethodName create(String methodName) {
                return new AutoValue_MethodInvocationMatcher_Token_MethodName(methodName);
            }
        }

        @AutoValue
        public static abstract class Kind
        implements Token {
            public abstract MethodKind kind();

            public static Kind create(MethodKind kind) {
                return new AutoValue_MethodInvocationMatcher_Token_Kind(kind);
            }

            public MethodKind comparisonKey() {
                return this.kind();
            }

            @Override
            public TokenType type() {
                return TokenType.KIND;
            }
        }
    }

    public static enum TokenType {
        KIND{

            MethodKind extract(Context ctx, VisitorState s2) {
                return ctx.sym.getKind() == ElementKind.CONSTRUCTOR ? MethodKind.CONSTRUCTOR : (ctx.sym.isStatic() ? MethodKind.STATIC : MethodKind.INSTANCE);
            }
        }
        ,
        METHOD_NAME{

            @Override
            String extract(Context ctx, VisitorState s2) {
                return ((Name)ctx.sym.getSimpleName()).toString();
            }
        }
        ,
        PARAMETER_TYPES{

            @Override
            ImmutableList<String> extract(Context ctx, VisitorState s2) {
                return ctx.sym.getParameters().stream().map(param -> param.type.tsym.getQualifiedName().toString()).collect(ImmutableList.toImmutableList());
            }
        }
        ,
        DEFINED_IN{

            @Override
            String extract(Context ctx, VisitorState s2) {
                return ctx.sym.owner.getQualifiedName().toString();
            }
        }
        ,
        RECEIVER_TYPE{

            @Override
            String extract(Context ctx, VisitorState s2) {
                return ASTHelpers.getReceiverType((ExpressionTree)ctx.tree).tsym.getQualifiedName().toString();
            }
        }
        ,
        RECEIVER_SUPERTYPE{

            @Override
            Type extract(Context ctx, VisitorState s2) {
                return ASTHelpers.getReceiverType((ExpressionTree)ctx.tree).tsym.type;
            }
        };


        abstract Object extract(Context var1, VisitorState var2);
    }

    public static enum MethodKind {
        STATIC,
        INSTANCE,
        CONSTRUCTOR;

    }

    static final class Context {
        final Symbol.MethodSymbol sym;
        final ExpressionTree tree;

        Context(Symbol.MethodSymbol sym, ExpressionTree tree) {
            this.sym = sym;
            this.tree = tree;
        }

        public static Optional<Context> create(ExpressionTree tree) {
            Symbol sym = ASTHelpers.getSymbol(tree);
            if (!(sym instanceof Symbol.MethodSymbol)) {
                return Optional.empty();
            }
            return Optional.of(new Context((Symbol.MethodSymbol)sym, tree));
        }
    }
}

