/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.errorprone.fixes.AutoValue_Replacement;

@AutoValue
public abstract class Replacement {
    public static Replacement create(int startPosition, int endPosition, String replaceWith) {
        Preconditions.checkArgument(startPosition >= 0 && startPosition <= endPosition, "invalid replacement: [%s, %s) (%s)", (Object)startPosition, (Object)endPosition, (Object)replaceWith);
        return new AutoValue_Replacement(Range.closedOpen(startPosition, endPosition), replaceWith);
    }

    public int startPosition() {
        return this.range().lowerEndpoint();
    }

    public int length() {
        return this.endPosition() - this.startPosition();
    }

    public int endPosition() {
        return this.range().upperEndpoint();
    }

    public abstract Range<Integer> range();

    public abstract String replaceWith();

    Replacement withDifferentText(String replaceWith) {
        return new AutoValue_Replacement(this.range(), replaceWith);
    }
}

