/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@BugPattern(summary="An value that appears to be represented in one unit is used where another appears to be required (e.g., seconds where nanos are needed)", severity=BugPattern.SeverityLevel.WARNING)
public final class TimeUnitMismatch
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableBiMap<TimeUnit, String> TIME_UNIT_TO_UNIT_METHODS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put((Object)TimeUnit.NANOSECONDS, "toNanos")).put((Object)TimeUnit.MICROSECONDS, "toMicros")).put((Object)TimeUnit.MILLISECONDS, "toMillis")).put((Object)TimeUnit.SECONDS, "toSeconds")).put((Object)TimeUnit.MINUTES, "toMinutes")).put((Object)TimeUnit.HOURS, "toHours")).put((Object)TimeUnit.DAYS, "toDays")).buildOrThrow();
    private static final Matcher<Tree> NUMERIC_TIME_TYPE = Matchers.anyOf(Matchers.isSameType(Suppliers.INT_TYPE), Matchers.isSameType(Suppliers.LONG_TYPE), Matchers.isSameType(Suppliers.DOUBLE_TYPE), Matchers.isSameType("java.lang.Integer"), Matchers.isSameType("java.lang.Long"), Matchers.isSameType("java.lang.Double"));
    private static final ImmutableSet<String> NUMBER_WORDS = ImmutableSet.of("one", "two", "three", "four", "five", "six", new String[]{"seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "twenty", "thirty", "forty", "fifty", "sixty"});
    private static final ImmutableMap<String, TimeUnit> UNIT_FOR_SUFFIX = ImmutableMap.copyOf(((ImmutableSetMultimap)((ImmutableSetMultimap)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)new ImmutableSetMultimap.Builder().putAll((Object)TimeUnit.SECONDS, new String[]{"sec", "secs", "second", "seconds"})).putAll((Object)TimeUnit.MILLISECONDS, new String[]{"milli", "millis", "mills", "ms", "msec", "msecs", "millisec", "millisecs", "millisecond", "milliseconds"})).putAll((Object)TimeUnit.MICROSECONDS, new String[]{"micro", "micros", "us", "usec", "usecs", "microsec", "microsecs", "microsecond", "microseconds"})).putAll((Object)TimeUnit.NANOSECONDS, new String[]{"nano", "nanos", "ns", "nsec", "nsecs", "nanosec", "nanosecs", "nanosecond", "nanoseconds"})).build()).inverse()).entries());
    private static final Description ANY_MATCHES_WERE_ALREADY_REPORTED = Description.NO_MATCH;
    private static final Supplier<Type> JAVA_UTIL_CONCURRENT_TIMEUNIT = VisitorState.memoize(state -> state.getTypeFromString("java.util.concurrent.TimeUnit"));

    @Override
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        String formalName = TimeUnitMismatch.extractArgumentName(tree.getVariable());
        if (formalName != null) {
            this.check(formalName, tree.getExpression(), state);
        }
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() != null) {
            this.check(tree.getName().toString(), tree.getInitializer(), state);
        }
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        this.checkAll(symbol.getParameters(), tree.getArguments(), state);
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        this.checkTimeUnitToUnit(tree, symbol, state);
        boolean setterMethodReported = this.checkSetterStyleMethod(tree, symbol, state);
        if (!setterMethodReported) {
            this.checkAll(symbol.getParameters(), tree.getArguments(), state);
        }
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    private boolean checkSetterStyleMethod(MethodInvocationTree tree, Symbol.MethodSymbol symbol, VisitorState state) {
        if (symbol.params().length() == 1 && ASTHelpers.isVoidType(symbol.getReturnType(), state) && tree.getArguments().size() == 1) {
            return this.check(symbol.name.toString(), tree.getArguments().get(0), state);
        }
        return false;
    }

    private boolean checkTimeUnitToUnit(MethodInvocationTree tree, Symbol.MethodSymbol methodSymbol, VisitorState state) {
        if (tree.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        MemberSelectTree memberSelect = (MemberSelectTree)tree.getMethodSelect();
        Symbol receiverSymbol = ASTHelpers.getSymbol(memberSelect.getExpression());
        if (receiverSymbol == null) {
            return false;
        }
        if (TimeUnitMismatch.isTimeUnit(receiverSymbol, state) && receiverSymbol.isEnum() && TIME_UNIT_TO_UNIT_METHODS.containsValue(((Name)methodSymbol.getSimpleName()).toString()) && tree.getArguments().size() == 1) {
            return this.check(receiverSymbol.getSimpleName().toString(), Iterables.getOnlyElement(tree.getArguments()), state);
        }
        return false;
    }

    private static boolean isTimeUnit(Symbol receiverSymbol, VisitorState state) {
        return ASTHelpers.isSameType(JAVA_UTIL_CONCURRENT_TIMEUNIT.get(state), receiverSymbol.type, state);
    }

    private boolean checkAll(List<Symbol.VarSymbol> formals, List<? extends ExpressionTree> actuals, VisitorState state) {
        if (formals.size() != actuals.size()) {
            return false;
        }
        boolean hasFinding = false;
        for (int i = 0; i < formals.size(); ++i) {
            hasFinding |= this.check(((Name)formals.get(i).getSimpleName()).toString(), actuals.get(i), state);
        }
        return hasFinding;
    }

    private boolean check(String formalName, ExpressionTree actualTree, VisitorState state) {
        if (!NUMERIC_TIME_TYPE.matches(actualTree, state)) {
            return false;
        }
        String actualName = TimeUnitMismatch.extractArgumentName(actualTree);
        if (actualName == null) {
            return false;
        }
        TimeUnit formalUnit = TimeUnitMismatch.unitSuggestedByName(formalName);
        TimeUnit actualUnit = TimeUnitMismatch.unitSuggestedByName(actualName);
        if (formalUnit == null || actualUnit == null || formalUnit == actualUnit) {
            return false;
        }
        Object message = String.format("Possible unit mismatch: expected %s but was %s. Before accepting this change, make sure that there is a true unit mismatch and not just an identifier whose name contains the wrong unit. (If there is, correct that instead!)", formalUnit.toString().toLowerCase(Locale.ROOT), actualUnit.toString().toLowerCase(Locale.ROOT));
        if (!(actualUnit != TimeUnit.MICROSECONDS && actualUnit != TimeUnit.MILLISECONDS || formalUnit != TimeUnit.MICROSECONDS && formalUnit != TimeUnit.MILLISECONDS)) {
            message = (String)message + " WARNING: This checker considers \"ms\" and \"msec\" to always refer to *milli*seconds. Occasionally, code uses them for *micro*seconds. If this error involves identifiers with those terms, be sure to check that it does mean milliseconds before accepting this fix. If it instead means microseconds, consider renaming to \"us\" or \"usec\" (or just \"micros\").";
        } else if (formalUnit == TimeUnit.SECONDS && actualUnit != TimeUnit.HOURS && actualUnit != TimeUnit.DAYS) {
            message = (String)message + " WARNING: The suggested replacement truncates fractional seconds, so a value like 999ms becomes 0.";
            message = (String)message + "Consider performing a floating-point division instead.";
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.addStaticImport(TimeUnit.class.getName() + "." + actualUnit);
        fix.prefixWith(actualTree, String.format("%s.%s(", new Object[]{actualUnit, TIME_UNIT_TO_UNIT_METHODS.get((Object)formalUnit)}));
        fix.postfixWith(actualTree, ")");
        state.reportMatch(this.buildDescription(actualTree).setMessage((String)message).addFix(fix.build()).build());
        return true;
    }

    @Nullable
    private static String extractArgumentName(ExpressionTree expr) {
        switch (expr.getKind()) {
            case TYPE_CAST: {
                return TimeUnitMismatch.extractArgumentName(((TypeCastTree)expr).getExpression());
            }
            case MEMBER_SELECT: {
                MemberSelectTree memberSelect = (MemberSelectTree)expr;
                String member = memberSelect.getIdentifier().toString();
                return member.equals("get") ? TimeUnitMismatch.extractArgumentName(memberSelect.getExpression()) : member;
            }
            case METHOD_INVOCATION: {
                Symbol sym = ASTHelpers.getSymbol(expr);
                if (sym == null) {
                    return null;
                }
                String methodName = sym.getSimpleName().toString();
                return methodName.equals("get") ? TimeUnitMismatch.extractArgumentName(((MethodInvocationTree)expr).getMethodSelect()) : methodName;
            }
            case IDENTIFIER: {
                IdentifierTree idTree = (IdentifierTree)expr;
                if (idTree.getName().contentEquals("this")) {
                    Symbol sym = ASTHelpers.getSymbol(idTree);
                    return sym == null ? null : ASTHelpers.enclosingClass(sym).getSimpleName().toString();
                }
                return ((IdentifierTree)expr).getName().toString();
            }
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    static TimeUnit unitSuggestedByName(String name) {
        if (name.equals("second") || name.equals("getSecond")) {
            return null;
        }
        if (name.equals("secondsPart")) {
            return TimeUnit.NANOSECONDS;
        }
        if (name.equals("msToS")) {
            return TimeUnit.SECONDS;
        }
        ImmutableList<String> words = TimeUnitMismatch.fixUnitCamelCase(NamingConventions.splitToLowercaseTerms(name));
        if (((String)words.get(0)).equals("second")) {
            return null;
        }
        if (TimeUnitMismatch.hasNameOfFromUnits(words)) {
            return null;
        }
        if (TimeUnitMismatch.isNamedForNumberOfUnits(words)) {
            return null;
        }
        ImmutableSet<TimeUnit> units = TimeUnitMismatch.timeUnits(words);
        return units.size() == 1 ? Iterables.getOnlyElement(units) : null;
    }

    private static boolean hasNameOfFromUnits(List<String> words) {
        return words.size() == 2 && words.get(0).equals("from") && UNIT_FOR_SUFFIX.containsKey(words.get(1));
    }

    private static boolean isNamedForNumberOfUnits(List<String> words) {
        return words.size() == 2 && NUMBER_WORDS.contains(words.get(0)) && UNIT_FOR_SUFFIX.containsKey(words.get(1));
    }

    private static ImmutableList<String> fixUnitCamelCase(List<String> words) {
        ImmutableList.Builder out = ImmutableList.builderWithExpectedSize(words.size());
        int i = 0;
        for (i = 0; i < words.size() - 1; ++i) {
            String next;
            String current = words.get(i);
            String together = current + (next = words.get(i + 1));
            if (UNIT_FOR_SUFFIX.containsKey(together)) {
                out.add(together);
                ++i;
                continue;
            }
            out.add(current);
        }
        if (i == words.size() - 1) {
            out.add(words.get(i));
        }
        return out.build();
    }

    private static ImmutableSet<TimeUnit> timeUnits(List<String> wordsLists) {
        return wordsLists.stream().map(UNIT_FOR_SUFFIX::get).filter(x -> x != null).collect(ImmutableSet.toImmutableSet());
    }
}

