/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.primitives.Longs;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.util.Name;
import java.util.concurrent.TimeUnit;

@BugPattern(summary="This TimeUnit conversion looks buggy: converting from a smaller unit to a larger unit (and passing a constant), converting to/from the same TimeUnit, or converting TimeUnits where the result is statically known to be 0 or 1 are all buggy patterns.", explanation="This checker flags potential problems with TimeUnit conversions: 1) conversions that are statically known to be equal to 0 or 1; 2) conversions that are converting from a given unit back to the same unit; 3) conversions that are converting from a smaller unit to a larger unit and passing a constant value", severity=BugPattern.SeverityLevel.WARNING)
public final class TimeUnitConversionChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.instanceMethod().onExactClass("java.util.concurrent.TimeUnit").namedAnyOf("toDays", "toHours", "toMinutes", "toSeconds", "toMillis", "toMicros", "toNanos");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiverOfConversion = ASTHelpers.getReceiver(tree);
        if (receiverOfConversion == null) {
            return Description.NO_MATCH;
        }
        String timeUnitName = ASTHelpers.getSymbol(receiverOfConversion).getSimpleName().toString();
        Optional<TimeUnit> receiver = Enums.getIfPresent(TimeUnit.class, timeUnitName);
        if (!receiver.isPresent()) {
            return Description.NO_MATCH;
        }
        String methodName = ((Name)ASTHelpers.getSymbol(tree).getSimpleName()).toString();
        TimeUnit convertTo = TimeUnitConversionChecker.methodNameToTimeUnit(methodName);
        ExpressionTree arg0 = tree.getArguments().get(0);
        Long constant = Longs.tryParse(String.valueOf(state.getSourceForNode(arg0)));
        if (constant != null) {
            long converted = TimeUnitConversionChecker.invokeConversion(receiver.get(), methodName, constant);
            if (converted == 0L || converted == 1L || constant == converted) {
                SuggestedFix fix = TimeUnitConversionChecker.replaceTreeWith(tree, convertTo, converted + "L");
                return this.describeMatch(tree, (Fix)fix);
            }
            if (receiver.get().compareTo(convertTo) < 0) {
                return this.describeMatch(tree);
            }
        }
        if (receiver.get().equals((Object)convertTo)) {
            SuggestedFix fix = TimeUnitConversionChecker.replaceTreeWith(tree, convertTo, state.getSourceForNode(arg0));
            return this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix replaceTreeWith(MethodInvocationTree tree, TimeUnit units, String replacement) {
        return SuggestedFix.builder().postfixWith(tree, " /* " + units.toString().toLowerCase() + " */").replace(tree, replacement).build();
    }

    private static long invokeConversion(TimeUnit timeUnit, String methodName, long duration) {
        switch (methodName) {
            case "toDays": {
                return timeUnit.toDays(duration);
            }
            case "toHours": {
                return timeUnit.toHours(duration);
            }
            case "toMinutes": {
                return timeUnit.toMinutes(duration);
            }
            case "toSeconds": {
                return timeUnit.toSeconds(duration);
            }
            case "toMillis": {
                return timeUnit.toMillis(duration);
            }
            case "toMicros": {
                return timeUnit.toMicros(duration);
            }
            case "toNanos": {
                return timeUnit.toNanos(duration);
            }
        }
        throw new IllegalArgumentException();
    }

    private static TimeUnit methodNameToTimeUnit(String methodName) {
        switch (methodName) {
            case "toDays": {
                return TimeUnit.DAYS;
            }
            case "toHours": {
                return TimeUnit.HOURS;
            }
            case "toMinutes": {
                return TimeUnit.MINUTES;
            }
            case "toSeconds": {
                return TimeUnit.SECONDS;
            }
            case "toMillis": {
                return TimeUnit.MILLISECONDS;
            }
            case "toMicros": {
                return TimeUnit.MICROSECONDS;
            }
            case "toNanos": {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new IllegalArgumentException();
    }
}

