/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StronglyType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import java.util.regex.Pattern;

@BugPattern(summary="This primitive integral type is only used to construct time types. It would be clearer to strongly type the field instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class StronglyTypeTime
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> TIME_FACTORY = Matchers.anyOf(Matchers.staticMethod().onClass("java.time.Duration").namedAnyOf("ofNanos", "ofMillis", "ofSeconds", "ofMinutes", "ofHours", "ofDays").withParameters("long", new String[0]), Matchers.staticMethod().onClass("java.time.Instant").namedAnyOf("ofEpochMilli", "ofEpochSecond").withParameters("long", new String[0]), Matchers.staticMethod().onClass("com.google.protobuf.util.Timestamps").namedAnyOf("fromNanos", "fromMicros", "fromMillis", "fromSeconds"), Matchers.staticMethod().onClass("com.google.protobuf.util.Durations").namedAnyOf("fromNanos", "fromMicros", "fromMillis", "fromSeconds", "fromMinutes", "fromHours", "fromDays"), Matchers.staticMethod().onClass("org.joda.time.Duration").namedAnyOf("millis", "standardSeconds", "standardMinutes", "standardHours", "standardDays").withParameters("long", new String[0]), Matchers.constructor().forClass("org.joda.time.Instant").withParameters("long", new String[0]), Matchers.staticMethod().onClass("org.joda.time.Instant").namedAnyOf("ofEpochMilli", "ofEpochSecond").withParameters("long", new String[0]), Matchers.constructor().forClass("org.joda.time.DateTime").withParameters("long", new String[0]));
    private static final Pattern TIME_UNIT_REMOVER = Pattern.compile("((_?IN)?_?(NANO|NANOSECOND|NSEC|_NS|MICRO|MSEC|USEC|MICROSECOND|MILLI|MILLISECOND|_MS|SEC|SECOND|MINUTE|MIN|HOUR|DAY)S?)?$", 2);

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        return StronglyType.forCheck(this).addType(state.getSymtab().intType).addType(state.getSymtab().longType).addType(state.getSymtab().floatType).addType(state.getSymtab().doubleType).setFactoryMatcher(TIME_FACTORY).setRenameFunction(StronglyTypeTime::createNewName).build().match(tree, state);
    }

    private static final String createNewName(String fieldName) {
        String newName = TIME_UNIT_REMOVER.matcher(fieldName).replaceAll("");
        return newName.isEmpty() ? fieldName : newName;
    }
}

