/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.DurationToLongTimeUnit;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.lang.model.type.TypeMirror;

@BugPattern(altNames={"PreferDurationOverload"}, summary="Prefer using java.time-based APIs when available. Note that this checker does not and cannot guarantee that the overloads have equivalent semantics, but that is generally the case with overloaded methods.", severity=BugPattern.SeverityLevel.WARNING)
public final class PreferJavaTimeOverload
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String JAVA_DURATION = "java.time.Duration";
    private static final String JODA_DURATION = "org.joda.time.Duration";
    private static final ImmutableMap<Matcher<ExpressionTree>, TimeUnit> JODA_DURATION_FACTORY_MATCHERS = new ImmutableMap.Builder<MethodMatchers.ParameterMatcher, TimeUnit>().put(Matchers.constructor().forClass("org.joda.time.Duration").withParameters("long", new String[0]), TimeUnit.MILLISECONDS).put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("millis")), TimeUnit.MILLISECONDS).put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardSeconds")), TimeUnit.SECONDS).put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardMinutes")), TimeUnit.MINUTES).put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardHours")), TimeUnit.HOURS).put((MethodMatchers.ParameterMatcher)((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardDays")), TimeUnit.DAYS).buildOrThrow();
    private static final ImmutableMap<TimeUnit, String> TIMEUNIT_TO_DURATION_FACTORY = new ImmutableMap.Builder<TimeUnit, String>().put(TimeUnit.NANOSECONDS, "%s.ofNanos(%s)").put(TimeUnit.MICROSECONDS, "%s.of(%s, %s)").put(TimeUnit.MILLISECONDS, "%s.ofMillis(%s)").put(TimeUnit.SECONDS, "%s.ofSeconds(%s)").put(TimeUnit.MINUTES, "%s.ofMinutes(%s)").put(TimeUnit.HOURS, "%s.ofHours(%s)").put(TimeUnit.DAYS, "%s.ofDays(%s)").buildOrThrow();
    private static final String JAVA_INSTANT = "java.time.Instant";
    private static final String JODA_INSTANT = "org.joda.time.Instant";
    private static final Matcher<ExpressionTree> JODA_INSTANT_CONSTRUCTOR_MATCHER = Matchers.constructor().forClass("org.joda.time.Instant").withParameters("long", new String[0]);
    private static final String TIME_SOURCE = "com.google.common.time.TimeSource";
    private static final String JODA_CLOCK = "com.google.common.time.Clock";
    private static final String JAVA_TIME_CONVERSIONS = "com.google.thirdparty.jodatime.JavaTimeConversions";
    private static final Matcher<ExpressionTree> TO_JODA_DURATION = MethodMatchers.staticMethod().onClass("com.google.thirdparty.jodatime.JavaTimeConversions").named("toJodaDuration");
    private static final Matcher<ExpressionTree> TO_JODA_INSTANT = MethodMatchers.staticMethod().onClass("com.google.thirdparty.jodatime.JavaTimeConversions").named("toJodaInstant");
    private static final Matcher<ExpressionTree> IGNORED_APIS = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.jooq.impl.DSL").withAnyName(), MethodMatchers.staticMethod().onClass((type, state) -> type.toString().startsWith("org.assertj.")).withAnyName(), MethodMatchers.instanceMethod().onDescendantOf("reactor.core.publisher.Flux").withAnyName());
    private static final Matcher<ExpressionTree> JAVA_DURATION_DECOMPOSITION_MATCHER = MethodMatchers.instanceMethod().onExactClass("java.time.Duration").namedAnyOf("toNanos", "toMillis", "getSeconds", "toMinutes", "toHours", "toDays");
    private final boolean hasJava8LibSupport;
    private static final Supplier<Type> JAVA_TIME_DURATION = VisitorState.memoize(state -> state.getTypeFromString(JAVA_DURATION));
    private static final Supplier<Type> JAVA_UTIL_CONCURRENT_TIMEUNIT = VisitorState.memoize(state -> state.getTypeFromString("java.util.concurrent.TimeUnit"));

    @Inject
    public PreferJavaTimeOverload(ErrorProneFlags flags) {
        this.hasJava8LibSupport = flags.getBoolean("Android:Java8Libs").orElse(false);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder fix;
        ExpressionTree arg0;
        String durationFactory;
        Optional<TimeUnit> optionalTimeUnit;
        if (state.isAndroidCompatible() && !this.hasJava8LibSupport) {
            return Description.NO_MATCH;
        }
        if (IGNORED_APIS.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        java.util.List<? extends ExpressionTree> arguments = tree.getArguments();
        if (PreferJavaTimeOverload.isNumericMethodCall(tree, state)) {
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_DURATION)) {
                return this.buildDescriptionForNumericPrimitive(tree, state, arguments, "Duration");
            }
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_INSTANT)) {
                return this.buildDescriptionForNumericPrimitive(tree, state, arguments, "Instant");
            }
        }
        if (PreferJavaTimeOverload.isLongTimeUnitMethodCall(tree, state) && (optionalTimeUnit = DurationToLongTimeUnit.getTimeUnit(arguments.get(1))).isPresent() && PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_DURATION) && (durationFactory = TIMEUNIT_TO_DURATION_FACTORY.get((Object)optionalTimeUnit.get())) != null) {
            MethodInvocationTree maybeDurationDecomposition;
            SuggestedFix.Builder fix2 = SuggestedFix.builder();
            String qualifiedDuration = SuggestedFixes.qualifyType(state, fix2, JAVA_DURATION);
            String value = state.getSourceForNode(arguments.get(0));
            String replacement = null;
            if (arguments.get(0) instanceof MethodInvocationTree && JAVA_DURATION_DECOMPOSITION_MATCHER.matches(maybeDurationDecomposition = (MethodInvocationTree)arguments.get(0), state) && ASTHelpers.isSameType(ASTHelpers.getReceiverType(maybeDurationDecomposition), JAVA_TIME_DURATION.get(state), state)) {
                replacement = state.getSourceForNode(ASTHelpers.getReceiver(maybeDurationDecomposition));
            }
            if (optionalTimeUnit.get() == TimeUnit.MICROSECONDS) {
                String qualifiedChronoUnit = SuggestedFixes.qualifyType(state, fix2, "java.time.temporal.ChronoUnit");
                replacement = String.format(durationFactory, qualifiedDuration, value, qualifiedChronoUnit + ".MICROS");
            }
            if (replacement == null) {
                replacement = String.format(durationFactory, qualifiedDuration, value);
            }
            fix2.replace(ASTHelpers.getStartPosition(arguments.get(0)), state.getEndPosition(arguments.get(1)), replacement);
            return this.describeMatch(tree, (Fix)fix2.build());
        }
        if (PreferJavaTimeOverload.isMethodCallWithSingleParameter(tree, state, "org.joda.time.ReadableDuration")) {
            arg0 = arguments.get(0);
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_DURATION)) {
                fix = SuggestedFix.builder();
                String qualifiedDuration = SuggestedFixes.qualifyType(state, fix, JAVA_DURATION);
                for (Map.Entry entry : JODA_DURATION_FACTORY_MATCHERS.entrySet()) {
                    String durationFactory2;
                    ExpressionTree jodaDurationCreation;
                    if (!((Matcher)entry.getKey()).matches(arg0, state)) continue;
                    String value = null;
                    if (arg0 instanceof MethodInvocationTree) {
                        jodaDurationCreation = (MethodInvocationTree)arg0;
                        value = state.getSourceForNode(jodaDurationCreation.getArguments().get(0));
                    }
                    if (arg0 instanceof NewClassTree) {
                        jodaDurationCreation = (NewClassTree)arg0;
                        value = state.getSourceForNode(jodaDurationCreation.getArguments().get(0));
                    }
                    if (value == null || (durationFactory2 = TIMEUNIT_TO_DURATION_FACTORY.get(entry.getValue())) == null) continue;
                    String replacement = String.format(durationFactory2, qualifiedDuration, value);
                    fix.replace(arg0, replacement);
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                if (TO_JODA_DURATION.matches(arg0, state)) {
                    fix.replace(arg0, state.getSourceForNode(((MethodInvocationTree)arg0).getArguments().get(0)));
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                fix.replace(arg0, String.format("%s.ofMillis(%s.getMillis())", qualifiedDuration, state.getSourceForNode(arg0)));
                return this.describeMatch(tree, (Fix)fix.build());
            }
        }
        if (PreferJavaTimeOverload.isMethodCallWithSingleParameter(tree, state, "org.joda.time.ReadableInstant")) {
            arg0 = arguments.get(0);
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_INSTANT)) {
                fix = SuggestedFix.builder();
                String qualifiedInstant = SuggestedFixes.qualifyType(state, fix, JAVA_INSTANT);
                if (JODA_INSTANT_CONSTRUCTOR_MATCHER.matches(arg0, state) && arg0 instanceof NewClassTree) {
                    NewClassTree jodaInstantCreation = (NewClassTree)arg0;
                    String value = state.getSourceForNode(jodaInstantCreation.getArguments().get(0));
                    fix.replace(arg0, String.format("%s.ofEpochMilli(%s)", qualifiedInstant, value));
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                if (TO_JODA_INSTANT.matches(arg0, state)) {
                    fix.replace(arg0, state.getSourceForNode(((MethodInvocationTree)arg0).getArguments().get(0)));
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                fix.replace(arg0, String.format("%s.ofEpochMilli(%s.getMillis())", qualifiedInstant, state.getSourceForNode(arg0)));
                return this.describeMatch(tree, (Fix)fix.build());
            }
        }
        return Description.NO_MATCH;
    }

    private Description buildDescriptionForNumericPrimitive(MethodInvocationTree tree, VisitorState state, java.util.List<? extends ExpressionTree> arguments, String javaTimeType) {
        return this.buildDescription(tree).setMessage(String.format("If the numeric primitive (%s) represents a %s, please call %s(%s) instead.", state.getSourceForNode(arguments.get(0)), javaTimeType, state.getSourceForNode(tree.getMethodSelect()), javaTimeType)).build();
    }

    private static boolean isNumericMethodCall(MethodInvocationTree tree, VisitorState state) {
        java.util.List params = ASTHelpers.getSymbol(tree).getParameters();
        if (params.size() == 1) {
            TypeMirror type0 = ((Symbol.VarSymbol)params.get(0)).asType();
            return ASTHelpers.isSameType((Type)type0, state.getSymtab().intType, state) || ASTHelpers.isSameType((Type)type0, state.getSymtab().longType, state) || ASTHelpers.isSameType((Type)type0, state.getSymtab().doubleType, state);
        }
        return false;
    }

    private static boolean isMethodCallWithSingleParameter(MethodInvocationTree tree, VisitorState state, String typeName) {
        Type type = state.getTypeFromString(typeName);
        java.util.List params = ASTHelpers.getSymbol(tree).getParameters();
        return params.size() == 1 && ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)params.get(0)).asType(), type, state);
    }

    private static boolean isLongTimeUnitMethodCall(MethodInvocationTree tree, VisitorState state) {
        Type.JCPrimitiveType longType = state.getSymtab().longType;
        Type timeUnitType = JAVA_UTIL_CONCURRENT_TIMEUNIT.get(state);
        java.util.List params = ASTHelpers.getSymbol(tree).getParameters();
        if (params.size() == 2) {
            return ASTHelpers.isSameType((Type)((Symbol.VarSymbol)params.get(0)).asType(), longType, state) && ASTHelpers.isSameType((Type)((Symbol.VarSymbol)params.get(1)).asType(), timeUnitType, state);
        }
        return false;
    }

    private static boolean hasJavaTimeOverload(MethodInvocationTree tree, VisitorState state, String typeName) {
        Symbol.MethodSymbol calledMethod = ASTHelpers.getSymbol(tree);
        return PreferJavaTimeOverload.hasJavaTimeOverload(state, typeName, calledMethod, calledMethod.name);
    }

    private static boolean hasJavaTimeOverload(VisitorState state, String typeName, Symbol.MethodSymbol calledMethod, Name methodName) {
        MethodTree t2 = (MethodTree)state.findEnclosing(MethodTree.class);
        Symbol.MethodSymbol enclosingMethod = t2 == null ? null : ASTHelpers.getSymbol(t2);
        Type type = state.getTypeFromString(typeName);
        return PreferJavaTimeOverload.hasMatchingMethods(methodName, input -> !input.equals(calledMethod) && !input.equals(enclosingMethod) && (enclosingMethod == null || !enclosingMethod.overrides((Symbol)input, (Symbol.TypeSymbol)input.owner, state.getTypes(), true)) && input.isStatic() == calledMethod.isStatic() && ((List)input.getParameters()).size() == 1 && ASTHelpers.isSameType((Type)((Symbol.VarSymbol)((List)input.getParameters()).get(0)).asType(), type, state) && ASTHelpers.isSameType(input.getReturnType(), calledMethod.getReturnType(), state), (Type)ASTHelpers.enclosingClass(calledMethod).asType(), state.getTypes());
    }

    private static boolean hasTimeSourceMethod(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol calledMethod = ASTHelpers.getSymbol(tree);
        String timeSourceBasedName = calledMethod.name.toString().replace("Clock", "TimeSource");
        return PreferJavaTimeOverload.hasJavaTimeOverload(state, TIME_SOURCE, calledMethod, state.getName(timeSourceBasedName));
    }

    private static boolean hasMatchingMethods(Name name, Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        Predicate<Symbol> matchesMethodPredicate = sym -> sym instanceof Symbol.MethodSymbol && predicate.test((Symbol.MethodSymbol)sym);
        for (Type superClass : types.closure(startClass)) {
            Symbol.TypeSymbol superClassSymbol = superClass.tsym;
            Scope.WriteableScope superClassSymbols = superClassSymbol.members();
            if (superClassSymbols == null || Iterables.isEmpty(ASTHelpers.scope(superClassSymbols).getSymbolsByName(name, matchesMethodPredicate, Scope.LookupKind.NON_RECURSIVE))) continue;
            return true;
        }
        return false;
    }
}

