/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.DurationGetTemporalUnit;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;

@BugPattern(summary="Period.get() only works with YEARS, MONTHS, or DAYS.", explanation="`Period.get(TemporalUnit)` only works when passed `ChronoUnit.YEARS`, `ChronoUnit.MONTHS`, or `ChronoUnit.DAYS`. All other values are guaranteed to throw an `UnsupportedTemporalTypeException`.", severity=BugPattern.SeverityLevel.ERROR)
public final class PeriodGetTemporalUnit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<ChronoUnit> INVALID_TEMPORAL_UNITS = ImmutableSet.copyOf(EnumSet.complementOf(EnumSet.of(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS)));
    private static final Matcher<ExpressionTree> MATCHER = Matchers.instanceMethod().onExactClass("java.time.Period").named("get").withParameters("java.time.temporal.TemporalUnit", new String[0]);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MATCHER.matches(tree, state) && DurationGetTemporalUnit.getInvalidChronoUnit(Iterables.getOnlyElement(tree.getArguments()), INVALID_TEMPORAL_UNITS).isPresent() ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

