/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.GeneratedMessageLite;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Optional;
import java.util.regex.Pattern;

public class NearbyCallers {
    private static final Matcher<ExpressionTree> IS_IMMUTABLE_PROTO_GETTER = MethodMatchers.instanceMethod().onDescendantOfAny(GeneratedMessage.class.getName(), GeneratedMessageLite.class.getName()).withNameMatching(Pattern.compile("get(?!CachedSize$|SerializedSize$).+")).withNoParameters();

    private NearbyCallers() {
    }

    static boolean containsCallToSameReceiverNearby(final MethodInvocationTree primaryMethod, final Matcher<ExpressionTree> secondaryMethodMatcher, final VisitorState state, final boolean checkProtoChains) {
        final ExpressionTree primaryMethodReceiver = ASTHelpers.getReceiver(primaryMethod);
        TreeScanner<Boolean, Void> scanner = new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return MoreObjects.firstNonNull(r1, Boolean.FALSE) != false || MoreObjects.firstNonNull(r2, Boolean.FALSE) != false;
            }

            @Override
            public Boolean visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return false;
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree secondaryMethod, Void unused) {
                if (((Boolean)super.visitMethodInvocation(secondaryMethod, unused)).booleanValue()) {
                    return true;
                }
                if (secondaryMethod == null || !secondaryMethodMatcher.matches(secondaryMethod, state)) {
                    return false;
                }
                ExpressionTree secondaryMethodReceiver = ASTHelpers.getReceiver(secondaryMethod);
                if (secondaryMethodReceiver == null) {
                    return false;
                }
                if (primaryMethodReceiver != null && ASTHelpers.sameVariable(primaryMethodReceiver, secondaryMethodReceiver)) {
                    return true;
                }
                return checkProtoChains && this.protoChainsMatch(primaryMethod, secondaryMethod);
            }

            private boolean protoChainsMatch(MethodInvocationTree primaryMethod2, MethodInvocationTree secondaryMethod) {
                ExpressionTree primaryRootAssignable = ASTHelpers.getRootAssignable(primaryMethod2);
                ExpressionTree secondaryRootAssignable = ASTHelpers.getRootAssignable(secondaryMethod);
                if (primaryRootAssignable == null || secondaryRootAssignable == null || !ASTHelpers.sameVariable(primaryRootAssignable, secondaryRootAssignable)) {
                    return false;
                }
                return NearbyCallers.buildProtoGetterChain(primaryMethod2, state).flatMap(primaryChain -> NearbyCallers.buildProtoGetterChain(secondaryMethod, state).map(primaryChain::equals)).orElse(false);
            }
        };
        ImmutableList<Tree> treesToScan = NearbyCallers.getNearbyTreesToScan(state);
        return !treesToScan.isEmpty() && (Boolean)scanner.scan(treesToScan, null) != false;
    }

    private static Optional<ImmutableList<Symbol>> buildProtoGetterChain(ExpressionTree expr, VisitorState state) {
        ImmutableList.Builder symbolChain = ImmutableList.builder();
        while (expr instanceof JCTree.JCMethodInvocation) {
            if (!IS_IMMUTABLE_PROTO_GETTER.matches(expr = ((JCTree.JCMethodInvocation)expr).getMethodSelect(), state)) {
                return Optional.empty();
            }
            if (expr instanceof JCTree.JCFieldAccess) {
                expr = ((JCTree.JCFieldAccess)expr).getExpression();
            }
            symbolChain.add(ASTHelpers.getSymbol(expr));
        }
        return Optional.of(symbolChain.build());
    }

    private static ImmutableList<Tree> getNearbyTreesToScan(VisitorState state) {
        for (Tree parent : state.getPath()) {
            switch (parent.getKind()) {
                case BLOCK: {
                    return ImmutableList.of(parent);
                }
                case LAMBDA_EXPRESSION: {
                    return ImmutableList.of();
                }
                case CLASS: {
                    ImmutableList.Builder treesToScan = ImmutableList.builder();
                    for (Tree tree : ((ClassTree)parent).getMembers()) {
                        ExpressionTree expressionTree;
                        if (!(tree instanceof VariableTree) || (expressionTree = ((VariableTree)tree).getInitializer()) == null) continue;
                        treesToScan.add(expressionTree);
                    }
                    return treesToScan.build();
                }
            }
        }
        return ImmutableList.of();
    }
}

