/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Use of JodaTime's type.withDurationAdded(long, int) (where <type> = {Duration,Instant,DateTime}). Please use type.withDurationAdded(Duration.millis(long), int) instead.", explanation="JodaTime's type.withDurationAdded(long, int) is often a source of bugs because the units of the parameters are ambiguous. Please use type.withDurationAdded(Duration.millis(long), int) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaWithDurationAddedLong
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf(Matchers.anyOf(Matchers.instanceMethod().onExactClass("org.joda.time.DateTime").named("withDurationAdded").withParameters("long", "int"), Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("withDurationAdded").withParameters("long", "int"), Matchers.instanceMethod().onExactClass("org.joda.time.Instant").named("withDurationAdded").withParameters("long", "int")), Matchers.not(Matchers.packageStartsWith("org.joda.time")));
    private static final Matcher<ExpressionTree> DURATION_GET_MILLIS_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.ReadableDuration").named("getMillis");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        String receiver = state.getSourceForNode(ASTHelpers.getReceiver(tree));
        Integer scalar = ASTHelpers.constValue(tree.getArguments().get(1), Integer.class);
        SuggestedFix.Builder builder = SuggestedFix.builder();
        if (Integer.valueOf(0).equals(scalar)) {
            builder.replace(tree, receiver);
        } else {
            ExpressionTree firstArgumentTree = tree.getArguments().get(0);
            Object firstArgumentReplacement = DURATION_GET_MILLIS_MATCHER.matches(firstArgumentTree, state) ? state.getSourceForNode(ASTHelpers.getReceiver(firstArgumentTree)) : SuggestedFixes.qualifyType(state, builder, "org.joda.time.Duration") + ".millis(" + state.getSourceForNode(firstArgumentTree) + ")";
            if (Integer.valueOf(1).equals(scalar)) {
                builder.replace(tree, receiver + ".plus(" + (String)firstArgumentReplacement + ")");
            } else if (Integer.valueOf(-1).equals(scalar)) {
                builder.replace(tree, receiver + ".minus(" + (String)firstArgumentReplacement + ")");
            } else {
                builder.replace(firstArgumentTree, (String)firstArgumentReplacement);
            }
        }
        return this.describeMatch(tree, (Fix)builder.build());
    }
}

