/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;

@BugPattern(summary="This may have surprising semantics, e.g. new Period(LocalDate.parse(\"1970-01-01\"), LocalDate.parse(\"1970-02-02\")).getDays() == 1, not 32.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaNewPeriod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String READABLE_PARTIAL = "org.joda.time.ReadablePartial";
    private static final String READABLE_INSTANT = "org.joda.time.ReadableInstant";
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf(MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.Period").namedAnyOf("getMonths", "getWeeks", "getDays", "getHours", "getMinutes", "getSeconds"), Matchers.receiverOfInvocation(Matchers.anyOf(Matchers.constructor().forClass("org.joda.time.Period").withParameters("long", "long"), Matchers.constructor().forClass("org.joda.time.Period").withParameters("org.joda.time.ReadablePartial", "org.joda.time.ReadablePartial"), Matchers.constructor().forClass("org.joda.time.Period").withParameters("org.joda.time.ReadableInstant", "org.joda.time.ReadableInstant"))));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MATCHER.matches(tree, state) ? this.describeMatch(tree, (Fix)JodaNewPeriod.generateFix(tree, state)) : Description.NO_MATCH;
    }

    private static SuggestedFix generateFix(MethodInvocationTree tree, VisitorState state) {
        NewClassTree receiver = (NewClassTree)ASTHelpers.getReceiver(tree);
        List<? extends ExpressionTree> arguments = receiver.getArguments();
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(receiver);
        String unit = ((MemberSelectTree)tree.getMethodSelect()).getIdentifier().toString().replace("get", "");
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        if (ASTHelpers.isSameType(state.getTypes().unboxedTypeOrType(methodSymbol.params().get((int)0).type), state.getSymtab().longType, state)) {
            String duration = SuggestedFixes.qualifyType(state, fixBuilder, "org.joda.time.Duration");
            return fixBuilder.replace(tree, String.format("new %s(%s, %s).getStandard%s()", duration, state.getSourceForNode(arguments.get(0)), state.getSourceForNode(arguments.get(1)), unit)).build();
        }
        String unitImport = SuggestedFixes.qualifyType(state, fixBuilder, "org.joda.time." + unit);
        return fixBuilder.replace(tree, String.format("%s.%sBetween(%s, %s).get%s()", unitImport, unit.toLowerCase(), state.getSourceForNode(arguments.get(0)), state.getSourceForNode(arguments.get(1)), unit)).build();
    }
}

