/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;

@BugPattern(summary="Use of certain JodaTime constructors are not allowed.", explanation="Use JodaTime's static factories instead of the ambiguous constructors.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaConstructors
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> SELF_USAGE = Matchers.packageStartsWith("org.joda.time");
    private static final Matcher<ExpressionTree> DURATION_CTOR = Matchers.constructor().forClass("org.joda.time.Duration").withParameters("long", new String[0]);
    private static final Matcher<ExpressionTree> INSTANT_CTOR_NO_ARG = Matchers.constructor().forClass("org.joda.time.Instant").withNoParameters();
    private static final Matcher<ExpressionTree> INSTANT_CTOR_LONG_ARG = Matchers.constructor().forClass("org.joda.time.Instant").withParameters("long", new String[0]);
    private static final Matcher<ExpressionTree> DATE_TIME_CTOR_NO_ARG = Matchers.constructor().forClass("org.joda.time.DateTime").withNoParameters();
    private static final Matcher<ExpressionTree> DATE_TIME_CTORS_ONE_ARG = Matchers.anyOf(Matchers.constructor().forClass("org.joda.time.DateTime").withParameters("org.joda.time.Chronology", new String[0]), Matchers.constructor().forClass("org.joda.time.DateTime").withParameters("org.joda.time.DateTimeZone", new String[0]));

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (SELF_USAGE.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (DURATION_CTOR.matches(tree, state)) {
            SuggestedFix fix = SuggestedFix.replace(ASTHelpers.getStartPosition(tree), ASTHelpers.getStartPosition(Iterables.getOnlyElement(tree.getArguments())), state.getSourceForNode(tree.getIdentifier()) + ".millis(");
            return this.describeMatch(tree, (Fix)fix);
        }
        if (INSTANT_CTOR_NO_ARG.matches(tree, state)) {
            SuggestedFix fix = SuggestedFix.replace(tree, JodaConstructors.getIdentifierSource(tree, state) + ".now()");
            return this.describeMatch(tree, (Fix)fix);
        }
        if (INSTANT_CTOR_LONG_ARG.matches(tree, state)) {
            SuggestedFix fix = SuggestedFix.replace(ASTHelpers.getStartPosition(tree), ASTHelpers.getStartPosition(Iterables.getOnlyElement(tree.getArguments())), JodaConstructors.getIdentifierSource(tree, state) + ".ofEpochMilli(");
            return this.describeMatch(tree, (Fix)fix);
        }
        if (DATE_TIME_CTOR_NO_ARG.matches(tree, state)) {
            SuggestedFix fix = SuggestedFix.replace(tree, JodaConstructors.getIdentifierSource(tree, state) + ".now()");
            return this.describeMatch(tree, (Fix)fix);
        }
        if (DATE_TIME_CTORS_ONE_ARG.matches(tree, state)) {
            SuggestedFix fix = SuggestedFix.replace(ASTHelpers.getStartPosition(tree), ASTHelpers.getStartPosition(Iterables.getOnlyElement(tree.getArguments())), JodaConstructors.getIdentifierSource(tree, state) + ".now(");
            return this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }

    private static String getIdentifierSource(NewClassTree tree, VisitorState state) {
        return state.getSourceForNode(tree.getIdentifier());
    }
}

