/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.NearbyCallers;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="period.getDays() only accesses the \"days\" portion of the Period, and doesn't represent the total span of time of the period. Consider using org.threeten.extra.Days to extract the difference between two civil dates if you want the whole time.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaPeriodGetDays
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> PERIOD_LOOK_AT_OTHERS = MethodMatchers.instanceMethod().onExactClass("java.time.Period").namedAnyOf("getMonths", "getYears", "getTotalMonths");
    private static final Matcher<ExpressionTree> PERIOD_GET_DAYS = Matchers.allOf(MethodMatchers.instanceMethod().onExactClass("java.time.Period").named("getDays"), Matchers.not(Matchers.packageStartsWith("java.")));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (PERIOD_GET_DAYS.matches(tree, state) && !NearbyCallers.containsCallToSameReceiverNearby(tree, PERIOD_LOOK_AT_OTHERS, state, false)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

