/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Use of java.time.Duration.withNanos(int) is not allowed.", explanation="Duration's withNanos(int) method is often a source of bugs because it returns a copy of the current Duration instance, but _only_ the nano field is mutated (the seconds field is copied directly). Use Duration.ofSeconds(duration.getSeconds(), nanos) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaDurationWithNanos
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf(Matchers.instanceMethod().onExactClass("java.time.Duration").named("withNanos").withParameters("int", new String[0]), Matchers.not(Matchers.packageStartsWith("java.time")));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        ExpressionTree nanosArg = Iterables.getOnlyElement(tree.getArguments());
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        String replacement = SuggestedFixes.qualifyType(state, builder, "java.time.Duration") + ".ofSeconds(" + state.getSourceForNode(receiver) + ".getSeconds(), ";
        builder.replace(ASTHelpers.getStartPosition(tree), ASTHelpers.getStartPosition(nanosArg), replacement);
        return this.describeMatch(tree, (Fix)builder.build());
    }
}

