/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.DurationGetTemporalUnit;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;

@BugPattern(summary="Instant APIs only work for NANOS, MICROS, MILLIS, SECONDS, MINUTES, HOURS, HALF_DAYS and DAYS.", severity=BugPattern.SeverityLevel.ERROR)
public final class InstantTemporalUnit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String INSTANT = "java.time.Instant";
    private static final String TEMPORAL_UNIT = "java.time.temporal.TemporalUnit";
    private static final Matcher<ExpressionTree> INSTANT_OF_LONG_TEMPORAL_UNIT = Matchers.allOf(Matchers.anyOf(MethodMatchers.instanceMethod().onExactClass("java.time.Instant").named("minus").withParameters("long", "java.time.temporal.TemporalUnit"), MethodMatchers.instanceMethod().onExactClass("java.time.Instant").named("plus").withParameters("long", "java.time.temporal.TemporalUnit"), MethodMatchers.instanceMethod().onExactClass("java.time.Instant").named("until").withParameters("java.time.temporal.Temporal", "java.time.temporal.TemporalUnit")), Matchers.not(Matchers.packageStartsWith("java.")));
    static final ImmutableSet<ChronoUnit> INVALID_TEMPORAL_UNITS = Arrays.stream(ChronoUnit.values()).filter(c -> !c.isTimeBased()).filter(c -> !c.equals(ChronoUnit.DAYS)).collect(Sets.toImmutableEnumSet());

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (INSTANT_OF_LONG_TEMPORAL_UNIT.matches(tree, state) && DurationGetTemporalUnit.getInvalidChronoUnit(tree.getArguments().get(1), INVALID_TEMPORAL_UNITS).isPresent()) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

