/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Map;

@BugPattern(name="StaticGuardedByInstance", summary="Writes to static fields should not be guarded by instance locks", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class StaticGuardedByInstance
extends BugChecker
implements BugChecker.SynchronizedTreeMatcher {
    @Override
    public Description matchSynchronized(SynchronizedTree tree, VisitorState state) {
        Symbol lock = ASTHelpers.getSymbol(ASTHelpers.stripParentheses(tree.getExpression()));
        if (!(lock instanceof Symbol.VarSymbol)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isStatic(lock)) {
            return Description.NO_MATCH;
        }
        SetMultimap<Symbol.VarSymbol, Tree> writes = WriteVisitor.scan(tree.getBlock());
        for (Map.Entry write : writes.entries()) {
            if (!((Symbol.VarSymbol)write.getKey()).isStatic()) continue;
            state.reportMatch(this.buildDescription((Tree)write.getValue()).setMessage(String.format("Write to static variable should not be guarded by instance lock '%s'", lock)).build());
        }
        return Description.NO_MATCH;
    }

    static class WriteVisitor
    extends TreeScanner<Void, Void> {
        private final SetMultimap<Symbol.VarSymbol, Tree> writes = LinkedHashMultimap.create();

        WriteVisitor() {
        }

        static SetMultimap<Symbol.VarSymbol, Tree> scan(Tree tree) {
            WriteVisitor visitor = new WriteVisitor();
            tree.accept(visitor, null);
            return visitor.writes;
        }

        private void recordWrite(ExpressionTree variable) {
            Symbol sym = ASTHelpers.getSymbol(variable);
            if (sym instanceof Symbol.VarSymbol) {
                this.writes.put((Symbol.VarSymbol)sym, variable);
            }
        }

        @Override
        public Void visitAssignment(AssignmentTree node, Void unused) {
            this.recordWrite(node.getVariable());
            return (Void)super.visitAssignment(node, null);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
            this.recordWrite(node.getVariable());
            return (Void)super.visitCompoundAssignment(node, null);
        }

        @Override
        public Void visitUnary(UnaryTree node, Void unused) {
            switch (node.getKind()) {
                case PREFIX_DECREMENT: 
                case PREFIX_INCREMENT: 
                case POSTFIX_DECREMENT: 
                case POSTFIX_INCREMENT: {
                    this.recordWrite(node.getExpression());
                    break;
                }
            }
            return (Void)super.visitUnary(node, null);
        }

        @Override
        public Void visitSynchronized(SynchronizedTree node, Void unused) {
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, Void unused) {
            return null;
        }
    }
}

