/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import java.util.Collection;
import org.pcollections.Empty;
import org.pcollections.PSet;

class HeldLockSet {
    final PSet<GuardedByExpression> locks;

    private HeldLockSet() {
        this(Empty.set());
    }

    private HeldLockSet(PSet<GuardedByExpression> locks) {
        this.locks = locks;
    }

    static HeldLockSet empty() {
        return new HeldLockSet();
    }

    @CheckReturnValue
    public HeldLockSet plus(GuardedByExpression lock) {
        return new HeldLockSet(this.locks.plus(lock));
    }

    @CheckReturnValue
    public HeldLockSet plusAll(Collection<GuardedByExpression> locks) {
        return new HeldLockSet(this.locks.plusAll(locks));
    }

    public Collection<GuardedByExpression> allLocks() {
        return this.locks;
    }

    public String toString() {
        return this.locks.toString();
    }
}

