/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.overloading;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.overloading.AutoValue_ParameterOrderingViolation;
import com.google.errorprone.bugpatterns.overloading.ParameterTree;
import com.sun.source.tree.MethodTree;
import java.util.stream.Collectors;

@AutoValue
abstract class ParameterOrderingViolation {
    ParameterOrderingViolation() {
    }

    public abstract MethodTree methodTree();

    public abstract ImmutableList<ParameterTree> actual();

    public abstract ImmutableList<ParameterTree> expected();

    public static Builder builder() {
        return new AutoValue_ParameterOrderingViolation.Builder();
    }

    public String getDescription() {
        return "The parameters of this method are inconsistent with other overloaded versions. A consistent order would be: " + this.getSuggestedSignature();
    }

    private String getSuggestedSignature() {
        return String.format("%s(%s)", this.methodTree().getName(), this.getSuggestedParameters());
    }

    private String getSuggestedParameters() {
        return this.expected().stream().map(ParameterTree::toString).collect(Collectors.joining(", "));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setMethodTree(MethodTree var1);

        abstract Builder setActual(ImmutableList<ParameterTree> var1);

        abstract Builder setExpected(ImmutableList<ParameterTree> var1);

        abstract ParameterOrderingViolation autoBuild();

        public ParameterOrderingViolation build() {
            int expectedParameterCount;
            ParameterOrderingViolation orderingViolation = this.autoBuild();
            int actualParametersCount = orderingViolation.actual().size();
            Preconditions.checkState(actualParametersCount == (expectedParameterCount = orderingViolation.expected().size()));
            return orderingViolation;
        }
    }
}

