/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.overloading;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.overloading.ParameterOrderingViolation;
import com.google.errorprone.bugpatterns.overloading.ParameterTrie;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@BugPattern(summary="The ordering of parameters in overloaded methods should be as consistent as possible (when viewed from left to right)", severity=BugPattern.SeverityLevel.WARNING)
public final class InconsistentOverloads
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        this.processClassMethods(this.getClassTreeMethods(classTree, state), state);
        return Description.NO_MATCH;
    }

    private void processClassMethods(List<MethodTree> classMethodTrees, VisitorState state) {
        for (List<MethodTree> groupMethods : InconsistentOverloads.getMethodGroups(classMethodTrees)) {
            this.processGroupMethods(groupMethods, state);
        }
    }

    private void processGroupMethods(List<MethodTree> groupMethodTrees, VisitorState state) {
        Preconditions.checkArgument(!groupMethodTrees.isEmpty());
        for (ParameterOrderingViolation violation : InconsistentOverloads.getViolations(groupMethodTrees)) {
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(violation.methodTree());
            if (!ASTHelpers.findSuperMethods(methodSymbol, state.getTypes()).isEmpty()) continue;
            Description.Builder description = this.buildDescription(violation.methodTree());
            description.setMessage(violation.getDescription());
            state.reportMatch(description.build());
        }
    }

    private static ImmutableList<ParameterOrderingViolation> getViolations(List<MethodTree> groupMethodTrees) {
        ImmutableList.Builder result = ImmutableList.builder();
        ParameterTrie trie = new ParameterTrie();
        for (MethodTree methodTree : InconsistentOverloads.sortedByArity(groupMethodTrees)) {
            Optional<ParameterOrderingViolation> violation = trie.extendAndComputeViolation(methodTree);
            violation.ifPresent(result::add);
        }
        return result.build();
    }

    private static ImmutableList<MethodTree> sortedByArity(Iterable<MethodTree> methodTrees) {
        return ImmutableList.sortedCopyOf(InconsistentOverloads.comparingArity().thenComparing(InconsistentOverloads.comparingPositions()), methodTrees);
    }

    private static Comparator<MethodTree> comparingPositions() {
        return Comparator.comparingInt(InconsistentOverloads::getStartPosition);
    }

    private static Comparator<MethodTree> comparingArity() {
        return Comparator.comparingInt(ParameterTrie::getMethodTreeArity);
    }

    private static Collection<List<MethodTree>> getMethodGroups(List<MethodTree> classMethods) {
        return classMethods.stream().collect(Collectors.groupingBy(MethodTree::getName)).values();
    }

    private ImmutableList<MethodTree> getClassTreeMethods(ClassTree classTree, VisitorState state) {
        List<? extends Tree> members = classTree.getMembers();
        return members.stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(m4 -> !this.isSuppressed((Tree)m4, state)).collect(ImmutableList.toImmutableList());
    }

    private static int getStartPosition(Tree tree) {
        return ASTHelpers.getStartPosition(tree);
    }
}

